% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FishSS.R
\name{FishSS}
\alias{FishSS}
\title{Assess Stock Status Based on Calculated Parameters}
\usage{
FishSS(data, LM_ratio, Pobj, Pmat, Popt)
}
\arguments{
\item{data}{A data frame containing the necessary columns for stock status calculation.}

\item{LM_ratio}{A numeric value representing the length at maturity ratio.}

\item{Pobj}{A numeric value representing the percentage objective.}

\item{Pmat}{A numeric value representing the percentage of mature fish.}

\item{Popt}{A numeric value representing the percentage of optimally sized fish.}
}
\value{
A numeric vector containing TSB40 and LSB25.
}
\description{
This function assesses the stock status based on parameters calculated by the FishPar function.
}
\examples{
utils::data("CPdata", package = "aLBI")
FishSS(CPdata, 0.75, 100, 30, 25)
}
