% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configuration.R
\docType{data}
\name{aPEAR.theme}
\alias{aPEAR.theme}
\title{Default theme configuration for aPEAR}
\format{
An object of class \code{aPEAR.theme.config} of length 9.
}
\usage{
aPEAR.theme
}
\value{
an object of class aPEAR.theme.config
}
\description{
A list with parameters for customizing the theme of the enrichment network plot.
}
\details{
colorBy: which column in the data should be used to color the nodes in
the enrichment network plot (default: 'NES')

nodeSize: which column in the data should be used to get the node size for the
enrichment network plot (default: 'setSize')

innerCutoff: similarity cutoff for within-cluster nodes (default: 0.1). Decreasing
this value results in greater connectivity within the nodes in the same cluster.
For example, innerCutoff = 0 would display all connections within the same cluster.

outerCutoff: similarity cutoff for between-cluster nodes (default: 0.5). Decreasing
this value results in greater connectivity between the nodes in different clusters.
For example, outerCutoff = 0 would display all connections between different clusters.

colorType: how to colour the nodes: 'nes' - will center around 0 with blue min and
red max, 'pval' - will use log transform on the colorBy column and adjust color range
(default: 'nes')

pCutoff: adjust p-value colouring cutoff when using \code{colorType = 'pval'} (default: -10)

drawEllipses: enable / disable ellipse drawing (default: FALSE)

fontSize: adjust cluster label font size (default: 3)

repelLabels: whether the cluster label positions should be corrected (default: FALSE)
}
\examples{
# Display the default theme configuration used by aPEAR
aPEAR.theme

# Update the theme to draw ellipses
settings <- aPEAR.theme
settings$drawEllipses <- TRUE
settings

}
\keyword{datasets}
