% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichmentNetwork.R
\name{enrichmentNetwork}
\alias{enrichmentNetwork}
\title{aPEAR enrichment network}
\usage{
enrichmentNetwork(
  enrichment,
  methods = aPEAR.methods,
  theme = aPEAR.theme,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{enrichment}{a data.frame containing enrichment results}

\item{methods}{object of class \code{aPEAR.methods.config}}

\item{theme}{object of class \code{aPEAR.theme.config}}

\item{verbose}{enable / disable log messages}

\item{...}{additional parameters (see \code{?aPEAR.methods} and \code{?aPEAR.theme})}
}
\value{
a \code{ggplot2} object
}
\description{
Creates an enrichment network plot. This function internally calls
\code{findPathClusters} to obtain pathway clusters and then \code{plotPathClusters}
to create the enrichment network visualization.
}
\examples{
\donttest{
# Load libraries
library(clusterProfiler)
library(DOSE)
library(org.Hs.eg.db)
data(geneList)

# Perform enrichment using clusterProfiler
enrich <- gseGO(geneList, OrgDb = org.Hs.eg.db, ont = 'CC')

# Create enrichment network visualization with default parameters
enrichmentNetwork(enrich@result)

# Create enrichment network visualization with repelled labels and elipses
enrichmentNetwork(enrich@result, repelLabels = TRUE, drawEllipses = TRUE)
}

}
\seealso{
\code{?findPathClusters}, \code{?plotPathClusters}
}
