% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPathClusters.R
\name{findPathClusters}
\alias{findPathClusters}
\title{Find pathway clusters}
\usage{
findPathClusters(enrichment, methods = aPEAR.methods, verbose = FALSE, ...)
}
\arguments{
\item{enrichment}{a data.frame containing enrichment results}

\item{methods}{methods for calculating the pathway clusters within the enrichment
result (object of class aPEAR.methods; default: aPEAR.methods)}

\item{verbose}{enable / disable log messages (default: FALSE)}

\item{...}{additional parameters (see \code{?aPEAR.methods})}
}
\value{
a list of two objects: \code{sim} - pathway similarity matrix; and
\code{clusters} - pathway clusters

a list of clusters and similarity matrix
}
\description{
Calculates the clusters within the enrichment data based on
pathway similarity.
}
\examples{
\donttest{
# Load libraries
library(clusterProfiler)
library(DOSE)
library(org.Hs.eg.db)
data(geneList)

# Perform enrichment using clusterProfiler
enrich <- gseGO(geneList, OrgDb = org.Hs.eg.db, ont = 'CC')

# Obtain clusters within the enriched pathways using default parameters
data <- findPathClusters(enrich@result)
data$clusters

# Obtain clusters within the enriched pathways using hierarchical clustering
# and minClusterSize = 1
data <- findPathClusters(enrich@result, cluster = 'hier', minClusterSize = 1)
data$clusters
}

}
