% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_planet.R
\name{canvas_planet}
\alias{canvas_planet}
\title{Paint a Planet on a Canvas}
\usage{
canvas_planet(colors, threshold = 4, iterations = 200, 
              starprob = 0.01, fade = 0.2,
              radius = NULL, center.x = NULL, center.y = NULL, 
              light.right = TRUE, width = 1500, height = 1500)
}
\arguments{
\item{colors}{a character specifying the colors used for the planet(s). Can also be a list where each entry is a vector of colors for each planet.}

\item{threshold}{a character specifying the threshold for a color take.}

\item{iterations}{the number of iterations of the planets}

\item{starprob}{the probability of drawing a star in outer space.}

\item{fade}{the fading factor.}

\item{radius}{a numeric (vector) specifying the radius of the planet(s).}

\item{center.x}{the x-axis coordinate(s) for the center(s) of the planet(s).}

\item{center.y}{the y-axis coordinate(s) for the center(s) of the planet(s).}

\item{light.right}{whether to draw the light from the right or the left.}

\item{width}{the width of the artwork in pixels.}

\item{height}{the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints one or multiple planets.
}
\examples{
\donttest{
# Sun behind Earth and Moon
set.seed(1)
colors <- list(c("khaki1", "lightcoral", "lightsalmon"),
               c("dodgerblue", "forestgreen", "white"), 
               c("gray", "darkgray", "beige"))
canvas_planet(colors, radius = c(800, 400, 150), 
              center.x = c(1, 500, 1100),
              center.y = c(1400, 500, 1000), 
              starprob = 0.005)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
