% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ecm}
\alias{ecm}
\title{Error Correction Model}
\usage{
ecm(y, X, output = TRUE)
}
\arguments{
\item{y}{a response of a numeric vector or univariate time series.}

\item{X}{an exogenous input of a numeric vector or a matrix for multivariate time series.}

\item{output}{a logical value indicating to print the results in R console.
The default is \code{TRUE}.}
}
\value{
An object with class "\code{lm}", which is the same results of \code{\link{lm}} for
fitting linear regression.
}
\description{
Fits an error correction model for univriate response.
}
\details{
An error correction model captures the short term relationship between the
response \code{y} and the exogenous input variable \code{X}. The model is defined as
\deqn{dy[t] = bold{\beta}[0]*dX[t] + \beta[1]*ECM[t-1] + e[t],}
where \eqn{d} is an operator of the first order difference, i.e.,
\eqn{dy[t] = y[t] - y[t-1]}, and \eqn{bold{\beta}[0]} is a coefficient vector with the
number of elements being the number of columns of \code{X} (i.e., the number
of exogenous input variables), and\eqn{ ECM[t-1] = y[t-1] - hat{y}[t-1]} which is the
main term in the sense that its coefficient \eqn{\beta[1]} explains the short term
dynamic relationship between \code{y} and \code{X}
in this model, in which \eqn{hat{y}[t]} is estimated from the linear regression model
\eqn{y[t] = bold{\alpha}*X[t] + u[t]}. Here, \eqn{e[t]} and \eqn{u[t]} are both error terms
but from different linear models.
}
\note{
Missing values are removed before the analysis. In the results, \code{dX} or
\code{dX1}, \code{dX2}, ... represents the first difference of each exogenous input
variable \code{X}, and \code{dy} is the first difference of response \code{y}.
}
\examples{
X <- matrix(rnorm(200),100,2)
y <- 0.1*X[,1] + 2*X[,2] + rnorm(100)
ecm(y,X)
}
\author{
Debin Qiu
}
\references{
Engle, Robert F.; Granger, Clive W. J. (1987). Co-integration and error correction:
Representation, estimation and testing. \emph{Econometrica}, 55 (2): 251-276.
}

