% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_pacbam_bychrom.R
\name{split_pacbam_bychrom}
\alias{split_pacbam_bychrom}
\title{Split PaCBAM ouputs by chromosomes}
\usage{
split_pacbam_bychrom(targetbed, pacbamfolder, pacbamfolder_bychrom)
}
\arguments{
\item{targetbed}{Genomic regions in the BED tab-delimited format.}

\item{pacbamfolder}{Folder with original outputs generated by PaCBAM. This folder should contain both .pabs and .pileups files.}

\item{pacbamfolder_bychrom}{Output folder in which subfolders for each sample will be created.}
}
\value{
Original data from PaCBAM split by chromosome in separate files, these are saved in two sub-folders 'pileup' and 'snvs', organized by sample.
}
\description{
Split PaCBAM ouputs by chromosomes
}
\examples{
targetbed <- system.file("extdata", "regions_toy.bed", package = "abemus")
pacbamfolder <- system.file("extdata", "pacbam_data", package = "abemus")
pacbamfolder_bychrom <- tempdir()
split_pacbam_bychrom(targetbed,pacbamfolder,pacbamfolder_bychrom)
}
