% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{ablasso_uv}
\alias{ablasso_uv}
\title{AB-LASSO Estimator Without Sample Splitting}
\usage{
ablasso_uv(Y, D)
}
\arguments{
\item{Y}{A \code{P} x \code{N} (number of time periods x number of individuals) matrix containing the outcome/response variable \code{Y}.}

\item{D}{A \code{P} x \code{N} (number of time periods x number of individuals) matrix containing the policy variable/treatment \code{D}.}
}
\value{
A list with three elements:
\itemize{
\item theta.hat: Estimated coefficients.
\item std.hat: Estimated Standard errors.
\item stat: T-Statistics.
}
}
\description{
Implements the AB-LASSO estimation method for the univariate model \eqn{Y_{it} = \alpha_{i} + \gamma_{t} + \theta_{1} Y_{i,t-1} + \theta_{2} D_{it} + \varepsilon_{it}}, without sample splitting. Note that \eqn{D_{it}} is predetermined with respect to \eqn{\varepsilon_{it}}.
}
\examples{
# Generate data
data1 <- generate_data(N = 300, P = 40)

# You can use your own data by providing matrices `Y` and `D`
results <- ablasso_uv(Y = data1$Y, D = data1$D)
print(results)
}
