% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palma_ratio.R
\name{palma_ratio}
\alias{palma_ratio}
\title{Palma Ratio}
\usage{
palma_ratio(
  accessibility_data,
  sociodemographic_data,
  opportunity,
  population,
  income,
  group_by = character(0)
)
}
\arguments{
\item{accessibility_data}{A data frame. The accessibility levels whose
inequality should be calculated. Must contain the columns \code{id} and any
others specified in \code{opportunity}.}

\item{sociodemographic_data}{A data frame. The distribution of
sociodemographic characteristics of the population in the study area cells.
Must contain the columns \code{id} and any others specified in \code{population} and
\code{income}.}

\item{opportunity}{A string. The name of the column in \code{accessibility_data}
with the accessibility levels to be considerend when calculating inequality
levels.}

\item{population}{A string. The name of the column in \code{sociodemographic_data}
with the number of people in each cell. Used to weigh accessibility levels
when calculating inequality.}

\item{income}{A string. The name of column in \code{sociodemographic_data} with
the income variable that should be used to classify the population in
socioeconomic groups. Please note that this variable should describe income
per capita (e.g. mean income per capita, household income per
capita, etc), instead of the total amount of income in each cell.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{accessibility_data} columns that should be used to group the
inequality estimates by. For example, if \code{accessibility_data} includes a
\code{departure_time} column that specifies the departure time that each entry
refers to, passing \code{"departure_time"} to this parameter results in
inequality estimates grouped by departure time.}
}
\value{
A data frame containing the inequality estimates for the study area.
}
\description{
Calculates the Palma Ratio of a given accessibility distribution. Originally
defined as the income share of the richest 10\% of a population divided by the
income share of the poorest 40\%, this measure has been adapted in transport
planning as the average accessibility of the richest 10\% divided by the
average accessibility of the poorest 40\%.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data_dir <- system.file("extdata", package = "accessibility")
travel_matrix <- readRDS(file.path(data_dir, "travel_matrix.rds"))
land_use_data <- readRDS(file.path(data_dir, "land_use_data.rds"))

access <- cumulative_cutoff(
  travel_matrix,
  land_use_data,
  cutoff = 30,
  opportunity = "jobs",
  travel_cost = "travel_time"
)

palma <- palma_ratio(
  access,
  sociodemographic_data = land_use_data,
  opportunity = "jobs",
  population = "population",
  income = "income_per_capita"
)
palma
\dontshow{\}) # examplesIf}
}
\seealso{
Other inequality: 
\code{\link{gini_index}()}
}
\concept{inequality}
