% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_import.R
\name{corpus_import}
\alias{corpus_import}
\title{Import annotation files into corpus object}
\usage{
corpus_import(x, createFullText = TRUE, assignMedia = TRUE)
}
\arguments{
\item{x}{Corpus object.}

\item{createFullText}{Logical; if \code{TRUE} full text will be created.}

\item{assignMedia}{Logical; if \code{TRUE} the folder(s) specified in \code{@paths.media.files} of your corpus object will be scanned for media.}
}
\value{
Corpus object.
}
\description{
Scans all path specified in if \code{x@paths.annotation.files} for annotation files.
Supported file formats will be loaded as transcript objects into the corpus object.
All previously loaded transcript objects will be deleted.
}
\details{
If \code{assignMedia=TRUE} the paths defined in \code{x@paths.media.files} will be scanned for media files.
Based on their file names the media files and annotations files will be matched.
Only the the file types set in \code{options()$act.fileformats.audio} and \code{options()$act.fileformats.video} will be recognized.
You can modify these options to recognize other media types.

See \code{@import.results} of the corpus object to check the results of importing the files.
To get a detailed overview of the corpus object use \code{act::info(x)}, for a summary use \code{act::info_summarized(x)}.
}
\examples{
library(act)

# The example files that come with the act library are located here:
path <- system.file("extdata", "examplecorpus", package="act")

# This is the examplecorpus object that comes with the library
examplecorpus

# Make sure that the input folder of the example corpus object is set correctly
examplecorpus@paths.annotation.files <- path
examplecorpus@paths.media.files <- path

# Load annotation files into the corpus object (again)
examplecorpus <- act::corpus_import(x=examplecorpus)

# Creating the full texts may take a long time.
# If you do NOT want to create the full texts immediately use the following command:
examplecorpus <- act::corpus_import(x=examplecorpus, createFullText=FALSE )
}
\seealso{
\link{corpus_new}, \link{examplecorpus}
}
