% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCMM.R
\name{updateGCMM}
\alias{updateGCMM}
\title{Extend GCMM analysis}
\usage{
updateGCMM(model, burnin = 0, sample = 10000)
}
\arguments{
\item{model}{Object of class \code{GCMM} that is produced by the \code{\link{GCMM}} function}

\item{burnin}{Number of iterations per MCMC chain to be discarded as a burn-in}

\item{sample}{Number of iterations per MCMC chain}
}
\value{
Returns an object of class \code{GCMM} with a list of analysis details and output; see \code{\link{GCMM}}. A mixture plot of the estimated activity curve is also printed.
}
\description{
Extend GCMM analysis using \code{\link[runjags]{extend.jags}} from package \code{runjags}
}
\examples{
\donttest{ updateFoxGCMM<-updateGCMM(FoxActivityGCMM) }

}
\seealso{
\code{\link{GCMM}} \code{\link[runjags]{extend.jags}}
}
