% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepArchetypesRawData_funct_multiv_robust.R
\name{stepArchetypesRawData_funct_multiv_robust}
\alias{stepArchetypesRawData_funct_multiv_robust}
\title{Archetype algorithm to raw data with the functional multivariate robust Frobenius norm}
\usage{
stepArchetypesRawData_funct_multiv_robust(data, numArch, numRep = 3, 
                            verbose = TRUE, saveHistory = FALSE, PM, prob, nbasis, nvars)
}
\arguments{
\item{data}{Data to obtain archetypes.}

\item{numArch}{Number of archetypes to compute, from 1 to \code{numArch}.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} times.}

\item{verbose}{If TRUE, the progress during execution is shown.}

\item{saveHistory}{Save execution steps.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}

\item{prob}{Probability with values in [0,1].}

\item{nbasis}{Number of basis.}

\item{nvars}{Number of variables.}
}
\value{
A list with the archetypes.
}
\description{
This is a slight modification of \code{\link[Anthropometry]{stepArchetypesRawData}}
to use the functional archetype algorithm with the multivariate Frobenius norm.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- growth$hgtm
hgtf <- growth$hgtf[,1:39]

# Create array:
nvars <- 2
data.array <- array(0, dim = c(dim(hgtm), nvars))
data.array[,,1] <- as.matrix(hgtm)
data.array[,,2] <- as.matrix(hgtf)
rownames(data.array) <- 1:nrow(hgtm)
colnames(data.array) <- colnames(hgtm)
str(data.array)

# Create basis:
nbasis <- 10
basis_fd <- create.bspline.basis(c(1,nrow(hgtm)), nbasis)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:nrow(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = data.array, basisobj = basis_fd)

X <- array(0, dim = c(dim(t(temp_fd$coefs[,,1])), nvars))
X[,,1] <- t(temp_fd$coef[,,1]) 
X[,,2] <- t(temp_fd$coef[,,2])

# Standardize the variables:
Xs <- X
Xs[,,1] <- scale(X[,,1])
Xs[,,2] <- scale(X[,,2])

lass <- stepArchetypesRawData_funct_multiv_robust(data = Xs, numArch = 3, 
                                                  numRep = 5, verbose = FALSE, 
                                                  saveHistory = FALSE, PM, prob = 0.8, 
                                                  nbasis, nvars)
str(lass)   
length(lass[[1]])
class(lass[[1]])  
class(lass[[1]][[5]]) 
}                                         

}
\author{
Guillermo Vinue
}
