% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobenius_norm_robust.R
\name{frobenius_norm_robust}
\alias{frobenius_norm_robust}
\title{Robust Frobenius norm}
\usage{
frobenius_norm_robust(m, prob)
}
\arguments{
\item{m}{Data matrix with the residuals. This matrix has 
the same dimensions as the original data matrix.}

\item{prob}{Probability with values in [0,1].}
}
\value{
Real number.
}
\description{
Computes the robust Frobenius norm.
}
\details{
Residuals are vectors. If there are p variables (columns),
for every observation there is a residual that there is 
a p-dimensional vector. If there are n observations, the
residuals are an n times p matrix.
}
\examples{
mat <- matrix(1:4, nrow = 2)
frobenius_norm_robust(mat, 0.8)
                 
}
\references{
Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2018, submitted,
\url{https://arxiv.org/abs/1810.00919}
}
\author{
Irene Epifanio
}
