% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_beta_params.R
\name{find_beta_params}
\alias{find_beta_params}
\title{Find beta distribution parameters from thresholds}
\usage{
find_beta_params(
  theta = NULL,
  boundary_target = NULL,
  boundary = "lower",
  interval_width = 0.95,
  n_dec = 0,
  max_n = 10000
)
}
\arguments{
\item{theta}{single numeric \verb{> 0} and \verb{< 1}, expected true event probability.}

\item{boundary_target}{single numeric \verb{> 0} and \verb{< 1}, target lower or upper
boundary of the interval.}

\item{boundary}{single character string, either \code{"lower"} (default) or
\code{"upper"}, used to select which boundary to use when finding appropriate
parameters for the \code{beta} distribution.}

\item{interval_width}{width of the credible interval whose lower/upper
boundary should be used (see \code{boundary_target}); must be \verb{> 0} and \verb{< 1};
defaults to \code{0.95}.}

\item{n_dec}{single non-negative integer; the returned parameters are rounded
to this number of decimals. Defaults to \code{0}, in which case the parameters
will correspond to whole number of patients.}

\item{max_n}{single integer \verb{> 0} (default \code{10000}), the maximum total sum of
the parameters, corresponding to the maximum total number of patients that
will be considered by the function when finding the optimal parameter
values. Corresponds to the maximum number of patients contributing
information to a beta prior; more than the default number of patients are
unlikely to be used in a beta prior.}
}
\value{
A single-row \code{data.frame} with five columns: the two shape parameters
of the beta distribution (\code{alpha}, \code{beta}), rounded according to \code{n_dec},
and the actual lower and upper boundaries of the interval and the median
(with appropriate names, e.g. \code{p2.5}, \code{p50}, and \code{p97.5} for a \verb{95\%}
interval), when using those rounded values.
}
\description{
Helper function to find a beta distribution with parameters corresponding
to the fewest possible patients with events/non-events and a specified event
proportion. Used in the \strong{Advanced example} vignette
(\code{vignette("Advanced-example", "adaptr")}) to derive \code{beta} prior
distributions for use in \emph{beta-binomial conjugate models}, based on a belief
that the true event probability lies within a specified percentile-based
interval (defaults to \verb{95\%}). May similarly be used by users to derive other
\code{beta} priors.
}
