% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.trial_spec}
\alias{print.trial_result}
\alias{print.trial_results}
\alias{print.trial_results_summary}
\title{Print methods for adaptive trial objects}
\usage{
\method{print}{trial_spec}(x, prob_digits = 3, ...)

\method{print}{trial_result}(x, prob_digits = 3, ...)

\method{print}{trial_results}(
  x,
  select_strategy = "control if available",
  select_last_arm = FALSE,
  select_preferences = NULL,
  te_comp = NULL,
  raw_ests = FALSE,
  restrict = NULL,
  digits = 1,
  ...
)

\method{print}{trial_results_summary}(x, digits = 1, ...)
}
\arguments{
\item{x}{object to print, see Details below.}

\item{prob_digits}{single integer, the number of digits used when printing
probabilities, allocation probabilities and softening powers.}

\item{...}{additional arguments, not used.}

\item{select_strategy}{single character string. For trials not stopped
due to superiority (or with only 1 arm remaining, if \code{select_last_arm} is
set to \code{TRUE} in trial designs with a common \code{control} arm; see below),
this parameter specifies which arm will be considered selected when
calculating trial design performance metrics (described below;
this corresponds to the consequence of an inconclusive trial, i.e., which
arm would then be used in practice).\cr
The following options are available and must be written exactly as below
(case sensitive, cannot be abbreviated):
\itemize{
\item \code{"control if available"} (default): selects the \strong{first}
\code{control} arm for trials with a common control arm \emph{\strong{if}} this arm
is active at end-of-trial, otherwise no arm will be selected. For
trial designs without a common \code{control}, no arm will be selected.
\item \code{"none"}: selects no arm in trials not ending with superiority.
\item \code{"control"}: similar to \code{"control if available"}, but will throw
an error for trial designs without a common \code{control} arm.
\item \code{"final control"}: selects the \strong{final} \code{control} arm regardless
of whether the trial was stopped for practical equivalence, futility,
or at the maximum sample size; this strategy can only be specified
for trial designs with a common \code{control} arm.
\item \code{"control or best"}: selects the \strong{first} \code{control} arm if still
active at end-of-trial, otherwise selects the best remaining arm
(defined as the remaining arm with the highest probability of being
the best in the final analysis). Only works for trial designs with a
common \code{control} arm.
\item \code{"best"}: selects the best remaining arm (as described under
\code{"control or best"}).
\item \code{"list or best"}: selects the first remaining arm from a specified
list (specified using \code{select_preferences}, technically a character
vector). If none of these arms are are active at end-of-trial, the best
remaining arm will be selected (as described above).
\item \code{"list"}: as specified above, but if no arms on the provided list
remain active at end-of-trial, no arm is selected.
}}

\item{select_last_arm}{single logical, defaults to \code{FALSE}. If \code{TRUE}, the
only remaining active arm (the last \code{control}) will be selected in trials
with a common \code{control} arm ending with \code{equivalence} or \code{futility}, before
considering the options specified in \code{select_strategy}. Must be \code{FALSE} for
trial designs without a common \code{control} arm.}

\item{select_preferences}{character vector specifying a number of arms used
for selection if one of the \code{"list or best"} or \code{"list"} options are
specified for \code{select_strategy}. Can only contain valid \code{arms}
available in the trial.}

\item{te_comp}{character string, treatment-effect comparator. Can be either
\code{NULL} (the default) in which case the \strong{first} \code{control} arm is used for
trial designs with a common control arm, or a single trial \code{arm}. Will be
used when calculating \code{sq_err_te} (the squared error of the treatment
effect comparing the selected arm to the comparator arm, as described
below).}

\item{raw_ests}{single logical. If \code{FALSE} (default), the
posterior estimates (\code{post_ests}, see \link{setup_trial} and
\link{run_trial}) will be used to calculate \code{sq_err} (the squared error of the
estimated compared to the specified effect in the selected arm) and
\code{sq_err_te} (the squared error of the treatment effect comparing the
selected arm to the comparator arm, as described for \code{te_comp} and below).
If \code{TRUE}, the raw estimates (\code{raw_ests}, see \link{setup_trial} and
\link{run_trial}) will be used instead of the posterior estimates.}

\item{restrict}{single character string or \code{NULL}. If \code{NULL} (default),
results are summarised for all simulations; if \verb{"superior}, results are
summarised for simulations ending with superiority only; if \code{"selected"},
results are summarised for simulations ending with a selected arm
(according to the specified arm selection strategy for simulations not
ending with superiority). Some summary measures (e.g., \code{prob_conclusive})
can only be calculated across all simulations and several are calculated
regardless of \code{restrict} settings, but have substantially different
interpretations if restricted.}

\item{digits}{single integer, number of digits to print for probabilities and
some other summary values (with 2 extra digits added for outcome rates).}
}
\value{
Invisibly returns \code{x}.
}
\description{
Prints contents of the first input \code{x} in a human-friendly way, see
\strong{Details} for more information.
}
\details{
The behaviour depends on the class of \code{x}:

\itemize{
\item \code{trial_spec}: prints a trial specification setup by
\link{setup_trial}, \link{setup_trial_binom} or \link{setup_trial_norm}.
}

\itemize{
\item \code{trial_result}: prints the results of a single trial simulated by
\link{run_trial}. More details are saved in the \code{trial_result} object and thus
printed if the \code{sparse} argument in \link{run_trial}/\link{run_trials} is set to
\code{FALSE}; if \code{TRUE}, fewer details are printed, but the omitted details are
available by printing the \code{trial_spec} object created by \link{setup_trial},
\link{setup_trial_binom} or \link{setup_trial_norm}.
}

\itemize{
\item \code{trial_results}: prints the results of multiple simulations
generated using \link{run_trials}. Further documentation on how multiple trials
are summarised before printing can be found in the \link{summary} function
documentation.
}

\itemize{
\item \code{trial_results_summary}: print method for summary of multiple simulations
of the same trial specification, generated by using the \link{summary} function on an
object generated by \link{run_trials}.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{trial_spec}: Trial specification

\item \code{trial_result}: Single trial result

\item \code{trial_results}: Multiple trial results

\item \code{trial_results_summary}: Summary of multiple trial results
}}

