% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.trial_results}
\title{Summary of simulated trial results}
\usage{
\method{summary}{trial_results}(
  object,
  select_strategy = "control if available",
  select_last_arm = FALSE,
  select_preferences = NULL,
  te_comp = NULL,
  raw_ests = FALSE,
  final_ests = NULL,
  restrict = NULL,
  cores = NULL,
  ...
)
}
\arguments{
\item{object}{\code{trial_results} object, output from the \code{\link[=run_trials]{run_trials()}}
function.}

\item{select_strategy}{single character string. If a trial was not stopped
due to superiority (or had only 1 arm remaining, if \code{select_last_arm} is
set to \code{TRUE} in trial designs with a common \code{control} arm; see below),
this parameter specifies which arm will be considered selected when
calculating trial design performance metrics, as described below;
this corresponds to the consequence of an inconclusive trial, i.e., which
arm would then be used in practice.\cr
The following options are available and must be written exactly as below
(case sensitive, cannot be abbreviated):
\itemize{
\item \code{"control if available"} (default): selects the \strong{first}
\code{control} arm for trials with a common \code{control} arm \emph{\strong{if}} this
arm is active at end-of-trial, otherwise no arm will be selected. For
trial designs without a common \code{control}, no arm will be selected.
\item \code{"none"}: selects no arm in trials not ending with superiority.
\item \code{"control"}: similar to \code{"control if available"}, but will throw
an error if used for trial designs without a common \code{control} arm.
\item \code{"final control"}: selects the \strong{final} \code{control} arm regardless
of whether the trial was stopped for practical equivalence, futility,
or at the maximum sample size; this strategy can only be specified
for trial designs with a common \code{control} arm.
\item \code{"control or best"}: selects the \strong{first} \code{control} arm if still
active at end-of-trial, otherwise selects the best remaining arm
(defined as the remaining arm with the highest probability of being
the best in the last adaptive analysis conducted). Only works for
trial designs with a common \code{control} arm.
\item \code{"best"}: selects the best remaining arm (as described under
\code{"control or best"}).
\item \code{"list or best"}: selects the first remaining arm from a specified
list (specified using \code{select_preferences}, technically a character
vector). If none of these arms are are active at end-of-trial, the best
remaining arm will be selected (as described above).
\item \code{"list"}: as specified above, but if no arms on the provided list
remain active at end-of-trial, no arm is selected.
}}

\item{select_last_arm}{single logical, defaults to \code{FALSE}. If \code{TRUE}, the
only remaining active arm (the last \code{control}) will be selected in trials
with a common \code{control} arm ending with \code{equivalence} or \code{futility}, before
considering the options specified in \code{select_strategy}. Must be \code{FALSE} for
trial designs without a common \code{control} arm.}

\item{select_preferences}{character vector specifying a number of arms used
for selection if one of the \code{"list or best"} or \code{"list"} options are
specified for \code{select_strategy}. Can only contain valid \code{arms}
available in the trial.}

\item{te_comp}{character string, treatment-effect comparator. Can be either
\code{NULL} (the default) in which case the \strong{first} \code{control} arm is used for
trial designs with a common control arm, or a string naming a single trial
\code{arm}. Will be used when calculating \code{sq_err_te} (the squared error of the
treatment effect comparing the selected arm to the comparator arm, as
described below).}

\item{raw_ests}{single logical. If \code{FALSE} (default), the
posterior estimates (\code{post_ests} or \code{post_ests_all}, see \code{\link[=setup_trial]{setup_trial()}}
and \code{\link[=run_trial]{run_trial()}}) will be used to calculate \code{sq_err} (the squared error of
the estimated compared to the specified effect in the selected arm) and
\code{sq_err_te} (the squared error of the treatment effect comparing the
selected arm to the comparator arm, as described for \code{te_comp} and below).
If \code{TRUE}, the raw estimates (\code{raw_ests} or \code{raw_ests_all}, see
\code{\link[=setup_trial]{setup_trial()}} and \code{\link[=run_trial]{run_trial()}}) will be used instead of the posterior
estimates.}

\item{final_ests}{single logical. If \code{TRUE} (recommended) the final estimates
calculated using outcome data from all patients randomised when trials are
stopped are used (\code{post_ests_all} or \code{raw_ests_all}, see \code{\link[=setup_trial]{setup_trial()}}
and \code{\link[=run_trial]{run_trial()}}); if \code{FALSE}, the estimates calculated for each arm when
an arm is stopped (or at the last adaptive analysis if not before) using
data from patients having reach followed up at this time point and not all
patients randomised are used (\code{post_ests} or \code{raw_ests}, see
\code{\link[=setup_trial]{setup_trial()}} and \code{\link[=run_trial]{run_trial()}}). If \code{NULL} (the default), this argument
will be set to \code{FALSE} if outcome data are available immediate after
randomisation for all patients (for backwards compatibility, as final
posterior estimates may vary slightly in this situation, even if using the
same data); otherwise it will be said to \code{TRUE}. See \code{\link[=setup_trial]{setup_trial()}} for
more details on how these estimates are calculated.}

\item{restrict}{single character string or \code{NULL}. If \code{NULL} (default),
results are summarised for all simulations; if \verb{"superior}, results are
summarised for simulations ending with superiority only; if \code{"selected"},
results are summarised for simulations ending with a selected arm only
(according to the specified arm selection strategy for simulations not
ending with superiority). Some summary measures (e.g., \code{prob_conclusive})
have substantially different interpretations if restricted, but are
calculated nonetheless.}

\item{cores}{\code{NULL} or single integer. If \code{NULL}, a default value set by
\code{\link[=setup_cluster]{setup_cluster()}} will be used to control whether extractions of simulation
results are done in parallel on a default cluster or sequentially in the
main process; if a value has not been specified by \code{\link[=setup_cluster]{setup_cluster()}},
\code{cores} will then be set to the value stored in the global \code{"mc.cores"}
option (if previously set by \verb{options(mc.cores = <number of cores>}), and
\code{1} if that option has not been specified.\cr
If \code{cores = 1}, computations
will be run sequentially in the primary process, and if \code{cores > 1}, a new
parallel cluster will be setup using the \code{parallel} library and removed
once the function completes. See \code{\link[=setup_cluster]{setup_cluster()}} for details.}

\item{...}{additional arguments, not used.}
}
\value{
A \code{"trial_results_summary"} object containing the following values:
\itemize{
\item \code{n_rep}: the number of simulations.
\item \code{n_summarised}: as described in \code{\link[=check_performance]{check_performance()}}.
\item \code{highest_is_best}: as specified in \code{\link[=setup_trial]{setup_trial()}}.
\item \code{elapsed_time}: the total simulation time.
\item \code{size_mean}, \code{size_sd}, \code{size_median}, \code{size_p25}, \code{size_p75},
\code{size_p0}, \code{size_p100}, \code{sum_ys_mean}, \code{sum_ys_sd}, \code{sum_ys_median},
\code{sum_ys_p25}, \code{sum_ys_p75}, \code{sum_ys_p0}, \code{sum_ys_p100}, \code{ratio_ys_mean},
\code{ratio_ys_sd}, \code{ratio_ys_median}, \code{ratio_ys_p25}, \code{ratio_ys_p75},
\code{ratio_ys_p0}, \code{ratio_ys_p100}, \code{prob_conclusive}, \code{prob_superior},
\code{prob_equivalence}, \code{prob_futility}, \code{prob_max}, \verb{prob_select_*} (with
\code{*} being all \code{arm} names), \code{rmse}, \code{rmse_te}, and \code{idp}: performance
metrics as described in \code{\link[=check_performance]{check_performance()}}. Note that all \code{sum_ys_}
and \code{ratio_ys_} measures uses outcome data from all randomised patients,
regardless of whether they had outcome data available at the last analysis
or not, as described in \code{\link[=extract_results]{extract_results()}}.
\item \code{select_strategy}, \code{select_last_arm}, \code{select_preferences},
\code{te_comp}, \code{raw_ests}, \code{final_ests}, \code{restrict}: as specified above.
\item \code{control}: the control arm specified by \code{\link[=setup_trial]{setup_trial()}},
\code{\link[=setup_trial_binom]{setup_trial_binom()}} or \code{\link[=setup_trial_norm]{setup_trial_norm()}}; \code{NULL} if no control.
\item \code{equivalence_assessed}, \code{futility_assessed}: single logicals,
specifies whether the trial design specification includes assessments of
equivalence and/or futility.
\item \code{base_seed}: as specified in \code{\link[=run_trials]{run_trials()}}.
\item \code{cri_width}, \code{n_draws}, \code{robust}, \code{description}, \code{add_info}: as
specified in \code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}} or
\code{\link[=setup_trial_norm]{setup_trial_norm()}}.
}
}
\description{
Summarises simulation results from the \code{\link[=run_trials]{run_trials()}} function. Uses
\code{\link[=extract_results]{extract_results()}} and \code{\link[=check_performance]{check_performance()}}, which may be used directly to
extract key trial results without summarising or to calculate performance
metrics (with uncertainty measures if desired) and return them in a tidy
\code{data.frame}.
}
\examples{
# Setup a trial specification
binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                 control = "A",
                                 true_ys = c(0.20, 0.18, 0.22, 0.24),
                                 data_looks = 1:20 * 100)

# Run 10 simulations with a specified random base seed
res <- run_trials(binom_trial, n_rep = 10, base_seed = 12345)

# Summarise simulations - select the control arm if available in trials not
# ending with a superiority decision
res_sum <- summary(res, select_strategy = "control")

# Print summary
print(res_sum, digits = 1)

}
\seealso{
\code{\link[=extract_results]{extract_results()}}, \code{\link[=check_performance]{check_performance()}}, \code{\link[=plot_convergence]{plot_convergence()}},
\code{\link[=plot_metrics_ecdf]{plot_metrics_ecdf()}}, \code{\link[=check_remaining_arms]{check_remaining_arms()}}.
}
