% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.block_diag}
\alias{matrix.block_diag}
\title{Creates a block-diagonal matrix.}
\usage{
matrix.block_diag(mats, method = c("naive", "cov"), n_threads = 1)
}
\arguments{
\item{mats}{List of matrices.}

\item{method}{Method type, with  default \code{method="naive"}.}

\item{n_threads}{Number of threads.}
}
\value{
Block-diagonal matrix.
}
\description{
Creates a block-diagonal matrix.
}
\examples{
n <- 100
ps <- c(10, 20, 30)
mats <- lapply(ps, function(p) {
    X <- matrix(rnorm(n * p), n, p)
    matrix.dense(t(X) \%*\% X, method="cov")
})
out <- matrix.block_diag(mats, method="cov")
mats <- lapply(ps, function(p) {
    X <- matrix(rnorm(n * p), n, p)
    matrix.dense(X, method="naive")
})
out <- matrix.block_diag(mats, method="naive")
}
\author{
Trevor Hastie and James Yang\cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
