% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entry_info.R
\name{adf_file_exists}
\alias{adf_file_exists}
\alias{adf_file_exists.adf_device}
\alias{adf_file_exists.virtual_path}
\alias{adf_dir_exists}
\alias{adf_dir_exists.adf_device}
\alias{adf_dir_exists.virtual_path}
\title{Test if an entry exists on a virtual device}
\usage{
adf_file_exists(x, path, ...)

\method{adf_file_exists}{adf_device}(x, path, ...)

\method{adf_file_exists}{virtual_path}(x, path, ...)

adf_dir_exists(x, path, ...)

\method{adf_dir_exists}{adf_device}(x, path, ...)

\method{adf_dir_exists}{virtual_path}(x, path, ...)
}
\arguments{
\item{x}{Either a virtual device or virtual path.}

\item{path}{A \code{\link[=virtual_path]{virtual_path()}} pointing to the targeted entry (file or directory). Should
be omitted when \code{x} is already a virtual path.}

\item{...}{Ignored}
}
\value{
\code{adf_file_exists()} returns \code{TRUE} if the path exists on the virtual device, \code{FALSE} otherwise.
\code{adf_dir_exists()} returns \code{TRUE} when the path exists and is a directory, \code{FALSE} otherwise.
}
\description{
Test if an entry (file or directory) exists on a virtual ADF device.
\code{adf_file_exists()} is the equivalent of \code{\link[=file.exists]{file.exists()}} on a virtual ADF device.
\code{adf_dir_exists()} is the equivalent of \code{\link[=dir.exists]{dir.exists()}} on a virtual ADF device.
}
\examples{
## First setup a connection to a virtual device
adz_file <- system.file("example.adz", package = "adfExplorer")
my_device <- connect_adf(adz_file)

adf_file_exists(my_device, "s/startup-sequence")
adf_dir_exists(my_device, "s/startup-sequence")

close(my_device)
}
\author{
Pepijn de Vries
}
