% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_flag.R
\name{derive_var_worst_flag}
\alias{derive_var_worst_flag}
\title{Adds a Variable Flagging the Maximal / Minimal Value Within a Group of Observations}
\usage{
derive_var_worst_flag(
  dataset,
  by_vars,
  order,
  new_var,
  param_var,
  analysis_var,
  worst_high,
  worst_low,
  filter = deprecated(),
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset.
Variables specified by \code{by_vars}, \code{order}, \code{param_var}, and \code{analysis_var} are expected.}

\item{by_vars}{Grouping variables

Permitted Values: list of variables}

\item{order}{Sort order.
Used to determine maximal / minimal observation if they are not unique,
see Details section for more information.}

\item{new_var}{Variable to add to the \code{dataset}.
It is set \code{"Y"} for the maximal / minimal observation of each group,
see Details section for more information.}

\item{param_var}{Variable with the parameter values for which the maximal / minimal
value is calculated.}

\item{analysis_var}{Variable with the measurement values for which the maximal / minimal
value is calculated.}

\item{worst_high}{Character with \code{param_var} values specifying the parameters
referring to "high".
Use \code{character(0)} if not required.}

\item{worst_low}{Character with \code{param_var} values specifying the parameters
referring to "low".
Use \code{character(0)} if not required.}

\item{filter}{Deprecated, please use \code{restrict_derivation()} instead (see examples).}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

Default: \code{"warning"}

Permitted Values: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
The input dataset with the new flag variable added.
}
\description{
Adds a Variable Flagging the Maximal / Minimal Value Within a Group of Observations
}
\details{
For each group with respect to the variables specified by the \code{by_vars} parameter,
the maximal / minimal observation of \code{analysis_var}
is labelled in the \code{new_var} column as \code{"Y"},
if its \code{param_var} is in \code{worst_high} / \code{worst_low}.
Otherwise, it is assigned \code{NA}.
If there is more than one such maximal / minimal observation,
the first one with respect to the order specified by the \code{order} parameter is flagged. The
direction of "worst" depends on the definition of worst for a specified parameters in the
arguments \code{worst_high} / \code{worst_low}, i.e. for some parameters the highest value is the worst
and for others the worst is the lowest value.
}
\examples{

input <- tibble::tribble(
  ~STUDYID, ~USUBJID,  ~PARAMCD,     ~AVISIT,                  ~ADT, ~AVAL,
  "TEST01",  "PAT01", "PARAM01",  "BASELINE", as.Date("2021-04-27"),  15.0,
  "TEST01",  "PAT01", "PARAM01",  "BASELINE", as.Date("2021-04-25"),  14.0,
  "TEST01",  "PAT01", "PARAM01",  "BASELINE", as.Date("2021-04-23"),  15.0,
  "TEST01",  "PAT01", "PARAM01",    "WEEK 1", as.Date("2021-04-27"),  10.0,
  "TEST01",  "PAT01", "PARAM01",    "WEEK 2", as.Date("2021-04-30"),  12.0,
  "TEST01",  "PAT02", "PARAM01", "SCREENING", as.Date("2021-04-27"),  15.0,
  "TEST01",  "PAT02", "PARAM01",  "BASELINE", as.Date("2021-04-25"),  14.0,
  "TEST01",  "PAT02", "PARAM01",  "BASELINE", as.Date("2021-04-23"),  15.0,
  "TEST01",  "PAT02", "PARAM01",    "WEEK 1", as.Date("2021-04-27"),  10.0,
  "TEST01",  "PAT02", "PARAM01",    "WEEK 2", as.Date("2021-04-30"),  12.0,
  "TEST01",  "PAT01", "PARAM02", "SCREENING", as.Date("2021-04-27"),  15.0,
  "TEST01",  "PAT01", "PARAM02", "SCREENING", as.Date("2021-04-25"),  14.0,
  "TEST01",  "PAT01", "PARAM02", "SCREENING", as.Date("2021-04-23"),  15.0,
  "TEST01",  "PAT01", "PARAM02",  "BASELINE", as.Date("2021-04-27"),  10.0,
  "TEST01",  "PAT01", "PARAM02",    "WEEK 2", as.Date("2021-04-30"),  12.0,
  "TEST01",  "PAT02", "PARAM02", "SCREENING", as.Date("2021-04-27"),  15.0,
  "TEST01",  "PAT02", "PARAM02",  "BASELINE", as.Date("2021-04-25"),  14.0,
  "TEST01",  "PAT02", "PARAM02",    "WEEK 1", as.Date("2021-04-23"),  15.0,
  "TEST01",  "PAT02", "PARAM02",    "WEEK 1", as.Date("2021-04-27"),  10.0,
  "TEST01",  "PAT02", "PARAM02",  "BASELINE", as.Date("2021-04-30"),  12.0,
  "TEST01",  "PAT02", "PARAM03", "SCREENING", as.Date("2021-04-27"),  15.0,
  "TEST01",  "PAT02", "PARAM03",  "BASELINE", as.Date("2021-04-25"),  14.0,
  "TEST01",  "PAT02", "PARAM03",    "WEEK 1", as.Date("2021-04-23"),  15.0,
  "TEST01",  "PAT02", "PARAM03",    "WEEK 1", as.Date("2021-04-27"),  10.0,
  "TEST01",  "PAT02", "PARAM03",  "BASELINE", as.Date("2021-04-30"),  12.0
)

derive_var_worst_flag(
  input,
  by_vars = vars(USUBJID, PARAMCD, AVISIT),
  order = vars(desc(ADT)),
  new_var = WORSTFL,
  param_var = PARAMCD,
  analysis_var = AVAL,
  worst_high = c("PARAM01", "PARAM03"),
  worst_low = "PARAM02"
)
\dontrun{
# example with ADVS
restrict_derivation(
  advs,
  derivation = derive_var_worst_flag,
  args = params(
    by_vars = vars(USUBJID, PARAMCD, AVISIT),
    order = vars(ADT, ATPTN),
    new_var = WORSTFL,
    param_var = PARAMCD,
    analysis_var = AVAL,
    worst_high = c("SYSBP", "DIABP"),
    worst_low = "RESP"
  ),
  filter = !is.na(AVISIT) & !is.na(AVAL)
)
}

}
\seealso{
\code{\link[=derive_var_extreme_flag]{derive_var_extreme_flag()}}

General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_merged_exist_flag}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{derive_vars_merged_lookup}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_transposed}()},
\code{\link{get_summary_records}()}
}
\author{
Ondrej Slama
}
\concept{der_gen}
\keyword{der_gen}
