% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admiral_options.R
\name{set_admiral_options}
\alias{set_admiral_options}
\title{Set the Value of Admiral Options}
\usage{
set_admiral_options(subject_keys)
}
\arguments{
\item{subject_keys}{Variables to uniquely identify a subject, defaults to
\code{vars(STUDYID, USUBJID)}. This option is used as default value for the
\code{subject_keys} argument in all admiral functions.}
}
\value{
No return value, called for side effects.
}
\description{
Set the Values of Admiral Options That Can Be Modified for Advanced Users.
}
\details{
Modify an admiral option, e.g \code{subject_keys}, such that it automatically affects downstream
function inputs where \code{get_admiral_option()} is called such as \code{derive_param_exist_flag()}.
}
\examples{
library(lubridate)
library(dplyr, warn.conflicts = FALSE)
library(tibble)
set_admiral_options(subject_keys = vars(STUDYID, USUBJID2))

# Derive a new parameter for measurable disease at baseline
adsl <- tribble(
  ~USUBJID2,
  "1",
  "2",
  "3"
) \%>\%
  mutate(STUDYID = "XX1234")

tu <- tribble(
  ~USUBJID2, ~VISIT,      ~TUSTRESC,
  "1",       "SCREENING", "TARGET",
  "1",       "WEEK 1",    "TARGET",
  "1",       "WEEK 5",    "TARGET",
  "1",       "WEEK 9",    "NON-TARGET",
  "2",       "SCREENING", "NON-TARGET",
  "2",       "SCREENING", "NON-TARGET"
) \%>\%
  mutate(
    STUDYID = "XX1234",
    TUTESTCD = "TUMIDENT"
  )

derive_param_exist_flag(
  dataset_adsl = adsl,
  dataset_add = tu,
  filter_add = TUTESTCD == "TUMIDENT" & VISIT == "SCREENING",
  condition = TUSTRESC == "TARGET",
  false_value = "N",
  missing_value = "N",
  set_values_to = vars(
    PARAMCD = "MDIS",
    PARAM = "Measurable Disease at Baseline"
  )
)
}
\seealso{
\code{\link[=vars]{vars()}}, \code{\link[=get_admiral_option]{get_admiral_option()}}, \code{\link[=derive_param_exist_flag]{derive_param_exist_flag()}},
\code{\link[=derive_param_first_event]{derive_param_first_event()}}, \code{\link[=derive_param_tte]{derive_param_tte()}}, \code{\link[=derive_var_disposition_status]{derive_var_disposition_status()}},
\code{\link[=derive_var_dthcaus]{derive_var_dthcaus()}}, \code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_vars_disposition_reason]{derive_vars_disposition_reason()}},
\code{\link[=derive_vars_period]{derive_vars_period()}}, \code{\link[=create_period_dataset]{create_period_dataset()}}

Other admiral_options: 
\code{\link{get_admiral_option}()}
}
\author{
Zelos Zhu
}
\concept{admiral_options}
\keyword{admiral_options}
