% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period_dataset.R
\name{derive_vars_period}
\alias{derive_vars_period}
\title{Add Subperiod, Period, or Phase Variables to ADSL}
\usage{
derive_vars_period(
  dataset,
  dataset_ref,
  new_vars,
  subject_keys = get_admiral_option("subject_keys")
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{subject_keys} argument are expected to be in the dataset.}

\item{dataset_ref}{Period reference dataset

The variables specified by \code{new_vars} and \code{subject_keys} are expected.

If subperiod variables are requested, \code{APERIOD} and \code{ASPER} are expected.
If period variables are requested. \code{APERIOD} is expected. If phase
variables are requested, \code{APHASEN} is expected.}

\item{new_vars}{New variables

A named list of variables like \code{exprs(PHwSDT = PHSDT, PHwEDT = PHEDT, APHASEw = APHASE)} is expected. The left hand side of the elements defines
a set of variables (in CDISC notation) to be added to the output dataset.
The right hand side defines the source variable from the period reference
dataset.

If the lower case letter "w"  is used it refers to a phase variable, if the
lower case letters "xx" are used it refers to a period variable, and if
both "xx" and "w" are used it refers to a subperiod variable.

Only one type must be used, e.g., all left hand side values must refer to
period variables. It is not allowed to mix for example period and subperiod
variables. If period \emph{and} subperiod variables are required, separate calls
must be used.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of expressions where the expressions are symbols as returned by
\code{exprs()} is expected.}
}
\value{
The input dataset with subperiod/period/phase variables added (see
"Details" section)
}
\description{
The function adds subperiod, period, or phase variables like \code{P01S1SDT},
\code{P01S2SDT}, \code{AP01SDTM}, \code{AP02SDTM}, \code{TRT01A}, \code{TRT02A}, \code{PH1SDT}, \code{PH2SDT},
... to the input dataset. The values of the variables are defined by a period
reference dataset which has one observations per patient and subperiod,
period, or phase.
}
\details{
For each subperiod/period/phase in the period reference dataset and
each element in \code{new_vars} a variable (LHS value of \code{new_vars}) is added to
the output dataset and set to the value of the source variable (RHS value
of \code{new_vars}.
}
\examples{
library(tibble)
library(dplyr, warn.conflicts = FALSE)
library(lubridate)

adsl <- tibble(STUDYID = "xyz", USUBJID = c("1", "2"))

# Add period variables to ADSL
period_ref <- tribble(
  ~USUBJID, ~APERIOD, ~APERSDT,     ~APEREDT,
  "1",             1, "2021-01-04", "2021-02-06",
  "1",             2, "2021-02-07", "2021-03-07",
  "2",             1, "2021-02-02", "2021-03-02",
  "2",             2, "2021-03-03", "2021-04-01"
) \%>\%
  mutate(
    STUDYID = "xyz",
    APERIOD = as.integer(APERIOD),
    across(matches("APER[ES]DT"), ymd)
  )

derive_vars_period(
  adsl,
  dataset_ref = period_ref,
  new_vars = exprs(APxxSDT = APERSDT, APxxEDT = APEREDT)
) \%>\%
  select(STUDYID, USUBJID, AP01SDT, AP01EDT, AP02SDT, AP02EDT)

# Add phase variables to ADSL
phase_ref <- tribble(
  ~USUBJID, ~APHASEN, ~PHSDT,       ~PHEDT,       ~APHASE,
  "1",             1, "2021-01-04", "2021-02-06", "TREATMENT",
  "1",             2, "2021-02-07", "2021-03-07", "FUP",
  "2",             1, "2021-02-02", "2021-03-02", "TREATMENT"
) \%>\%
  mutate(
    STUDYID = "xyz",
    APHASEN = as.integer(APHASEN),
    across(matches("PH[ES]DT"), ymd)
  )

derive_vars_period(
  adsl,
  dataset_ref = phase_ref,
  new_vars = exprs(PHwSDT = PHSDT, PHwEDT = PHEDT, APHASEw = APHASE)
) \%>\%
  select(STUDYID, USUBJID, PH1SDT, PH1EDT, PH2SDT, PH2EDT, APHASE1, APHASE2)

# Add subperiod variables to ADSL
subperiod_ref <- tribble(
  ~USUBJID, ~APERIOD, ~ASPER, ~ASPRSDT,     ~ASPREDT,
  "1",             1,      1, "2021-01-04", "2021-01-19",
  "1",             1,      2, "2021-01-20", "2021-02-06",
  "1",             2,      1, "2021-02-07", "2021-03-07",
  "2",             1,      1, "2021-02-02", "2021-03-02",
  "2",             2,      1, "2021-03-03", "2021-04-01"
) \%>\%
  mutate(
    STUDYID = "xyz",
    APERIOD = as.integer(APERIOD),
    ASPER = as.integer(ASPER),
    across(matches("ASPR[ES]DT"), ymd)
  )

derive_vars_period(
  adsl,
  dataset_ref = subperiod_ref,
  new_vars = exprs(PxxSwSDT = ASPRSDT, PxxSwEDT = ASPREDT)
) \%>\%
  select(STUDYID, USUBJID, P01S1SDT, P01S1EDT, P01S2SDT, P01S2EDT, P02S1SDT, P02S1EDT)
}
\seealso{
\code{\link[=create_period_dataset]{create_period_dataset()}}

ADSL Functions that returns variable appended to dataset: 
\code{\link{derive_var_age_years}()},
\code{\link{derive_vars_aage}()},
\code{\link{derive_vars_extreme_event}()}
}
\concept{der_adsl}
\keyword{der_adsl}
