% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_expr_list}
\alias{assert_expr_list}
\title{Is an Argument a List of Expressions?}
\usage{
assert_expr_list(
  arg,
  required_elements = NULL,
  named = FALSE,
  optional = FALSE
)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{required_elements}{A \code{character} vector of names that must be present in \code{arg}}

\item{named}{If set to \code{TRUE}, an error is issued if not all elements of the
list are named.}

\item{optional}{Is the checked argument optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown.}
}
\value{
The function throws an error if \code{arg} is not a list of expressions.
Otherwise, the input it returned invisibly.
}
\description{
Checks if the argument is a list of expressions.
}
\examples{
library(rlang)

example_fun <- function(vars) {
  assert_expr_list(vars)
}
example_fun(exprs(DTHDOM = "AE", DTHSEQ = AESEQ))

try(example_fun(exprs("AE", DTSEQ = AESEQ, !!list("a"))))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
