% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_starts.R
\name{get_semirandom}
\alias{get_semirandom}
\title{Generate initial semi-random start}
\usage{
get_semirandom(data, nclusters, seed = NULL)
}
\arguments{
\item{data}{Object-by-variable data matrix of class \code{matrix} or
\code{data.frame}.}

\item{nclusters}{Number of clusters to be used. Must be a positive integer.}

\item{seed}{Integer. Seed for the random number generator. Default: NULL}
}
\value{
\code{get_semirandom} returns a list with the following components:
  \describe{
  \item{\code{type}}{A character string denoting the type of start
  ('Semi-random Start')}
  \item{\code{A}}{An initial Membership matrix}}
}
\description{
Generate an initial semi-random start for the (low dimensional) Additive
Profile Clustering
algorithm (see \code{\link{adproclus}} and \code{\link{adproclus_low_dim}}).
}
\details{
An initial cluster membership matrix \eqn{A} is generated by
finding the best \eqn{A} conditional
on an initial profile matrix
\eqn{P} generated by drawing \emph{k} randomly chosen, distinct,
 rows from \code{data} (for details, see Depril et al., 2012).

\strong{Warning:} This function does \emph{not} obtain an ADPRCOLUS model. To
perform aditive profile clustering, see \code{\link{adproclus}}.
}
\examples{
# Obtain data from data set "Stackloss" and generate start allocation
start_allocation <- get_semirandom(stackloss, 3)$A

}
\references{
Wilderjans, T. F., Ceulemans, E., Van Mechelen, I., & Depril, D.
  (2010). ADPROCLUS: a graphical user interface for fitting additive profile
  clustering models to object by variable data matrices. \emph{Behavior
  Research Methods, 43}(1), 56-65.

  Depril, D., Van Mechelen, I., & Mirkin, B. (2008). Algorithms for additive
  clustering of rectangular data tables. \emph{Computational Statistics and
  Data Analysis, 52,} 4923-4938.

  #' Depril, D., Van Mechelen, I., & Wilderjans, T. F.
  (2012). Lowdimensional additive overlapping clustering.
  \emph{Journal of classification, 29,} 297-320.
}
\seealso{
\describe{
  \item{\code{\link{adproclus}}, \code{\link{adproclus_low_dim}}}{for details
   about membership and profile matrices}
  \item{\code{\link{get_random}}}{for generating random starts}
  \item{\code{\link{get_rational}}}{for generating rational starts}
}
}
