% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord.r
\name{Coord2D}
\alias{Coord2D}
\title{2D coordinate vector R6 Class}
\description{
\code{Coord2D} is an \code{\link[R6:R6Class]{R6::R6Class()}} object representing two-dimensional points
represented by Cartesian Coordinates.
}
\examples{
p <- as_coord2d(x = rnorm(100, 2), y = rnorm(100, 2))
print(p, n = 10)
pc <- mean(p) # Centroid
# method chained affine transformation matrices are auto-pre-multiplied
p$
  translate(-pc)$
  shear(x = 1, y = 0)$
  reflect("x-axis")$
  rotate(90, "degrees")$
  print(n = 10)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{xyw}}{A three-column matrix representing the homogeneous coordinates.
The first two columns are "x" and "y" coordinates
and the third column is all ones.}

\item{\code{x}}{A numeric vector of x-coordinates.}

\item{\code{y}}{A numeric vector of y-coordinates.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Coord2D-new}{\code{Coord2D$new()}}
\item \href{#method-Coord2D-permute}{\code{Coord2D$permute()}}
\item \href{#method-Coord2D-print}{\code{Coord2D$print()}}
\item \href{#method-Coord2D-project}{\code{Coord2D$project()}}
\item \href{#method-Coord2D-reflect}{\code{Coord2D$reflect()}}
\item \href{#method-Coord2D-rotate}{\code{Coord2D$rotate()}}
\item \href{#method-Coord2D-scale}{\code{Coord2D$scale()}}
\item \href{#method-Coord2D-shear}{\code{Coord2D$shear()}}
\item \href{#method-Coord2D-translate}{\code{Coord2D$translate()}}
\item \href{#method-Coord2D-transform}{\code{Coord2D$transform()}}
\item \href{#method-Coord2D-clone}{\code{Coord2D$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-new"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$new(xyw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xyw}}{A matrix with three columns representing (homogeneous) coordinates.
The first two columns represent x and y coordinates and
the last column is all ones.
Column names should be "x", "y", and "w".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-permute"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-permute}{}}}
\subsection{Method \code{permute()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$permute(permutation = c("xy", "yx"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{permutation}}{Either "xy" (no permutation) or "yx" (permute x and y axes)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-print"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$print(n = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of coordinates to print.  If \code{NULL} print all of them.}

\item{\code{...}}{Passed to \code{\link[=format.default]{format.default()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-project"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-project}{}}}
\subsection{Method \code{project()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$project(line = as_line2d("x-axis"), ..., scale = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{A \link{Line2D} object of length one representing the line
you with to reflect across or project to or an object coercible to one by \code{as_line2d(line, ...)}
such as "x-axis" or "y-axis".}

\item{\code{...}}{Passed to \code{\link[=project2d]{project2d()}}}

\item{\code{scale}}{Oblique projection scale factor.
A degenerate \code{0} value indicates an orthogonal projection.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-reflect"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-reflect}{}}}
\subsection{Method \code{reflect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$reflect(line = as_line2d("x-axis"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{A \link{Line2D} object of length one representing the line
you with to reflect across or project to or an object coercible to one by \code{as_line2d(line, ...)}
such as "x-axis" or "y-axis".}

\item{\code{...}}{Passed to \code{\link[=reflect2d]{reflect2d()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-rotate}{}}}
\subsection{Method \code{rotate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$rotate(theta = angle(0), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theta}}{An \code{\link[=angle]{angle()}} object of length one or an object coercible to one by \code{as_angle(theta, ...)}.}

\item{\code{...}}{Passed to \code{\link[=as_angle]{as_angle()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-scale"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-scale}{}}}
\subsection{Method \code{scale()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$scale(x_scale = 1, y_scale = x_scale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_scale}}{Scaling factor to apply to x coordinates}

\item{\code{y_scale}}{Scaling factor to apply to y coordinates}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-shear"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-shear}{}}}
\subsection{Method \code{shear()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$shear(xy_shear = 0, yx_shear = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xy_shear}}{Horizontal shear factor: \code{x = x + xy_shear * y}}

\item{\code{yx_shear}}{Vertical shear factor: \code{y = yx_shear * x + y}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-translate"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-translate}{}}}
\subsection{Method \code{translate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$translate(x = as_coord2d(0, 0), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A \link{Coord2D} object of length one or an object coercible to one by \code{as_coord2d(x, ...)}.}

\item{\code{...}}{Passed to \code{as_coord2d(x, ...)} if \code{x} is not a \link{Coord2D} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-transform"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-transform}{}}}
\subsection{Method \code{transform()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$transform(mat = transform2d())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{A 3x3 matrix representing a post-multiplied affine transformation matrix.
The last \strong{column} must be equal to \code{c(0, 0, 1)}.
If the last \strong{row} is \code{c(0, 0, 1)} you may need to transpose it
to convert it from a pre-multiplied affine transformation matrix to a post-multiplied one.
If a 2x2 matrix (such as a 2x2 post-multiplied 2D rotation matrix)
we'll quietly add a final column/row equal to \code{c(0, 0, 1)}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord2D-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Coord2D-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord2D$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
