% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgstbyuni.R
\name{lgstbyuni}
\alias{lgstbyuni}
\title{Univariate estimates of AFT model with log logistic distribution using MCMC.}
\usage{
lgstbyuni(m, n, STime, Event, nc, ni, data)
}
\arguments{
\item{m}{Starting column number of covariates of study from high dimensional entered data.}

\item{n}{Ending column number of covariates of study from high dimensional entered data.}

\item{STime}{name of survival time in data}

\item{Event}{name of event in data}

\item{nc}{number of chain used in model.}

\item{ni}{number of iteration used in model.}

\item{data}{High dimensional gene expression data that contains event status, survival time and and set of covariates.}
}
\value{
Data frame is containing posterior estimates (Coef, SD, Credible Interval, Rhat, n.eff) of regression coefficient of selected covariates and deviance. Result shows together for all covariates chosen from column m to n.
}
\description{
Provides estimate of AFT model with log logistic distribution using MCMC for univariate in high dimensional gene expression data. It also deals covariates with missing values.
}
\details{
This function deals covariates (in data) with missing values. Missing value in any column (covariate) is replaced by mean of that particular covariate.
AFT model is log-linear regression model for survival time \eqn{ T_{1}},\eqn{ T_{2}},..,\eqn{T_{n}}.
i.e., \deqn{log(T_i)= x_i'\beta +\sigma\epsilon_i ;~\epsilon_i \sim F_\epsilon (.)~which~is~iid }
Where \eqn{ F_\epsilon } is known cdf which is defined on real line.
When baseline distribution is logistic then T follows log logistic distribution.
\deqn{ T \sim Log-Logis(x'\beta,\sqrt{\tau)} }
}
\examples{
##
data(hdata)
lgstbyuni(12,14,STime="os",Event="death",5,10,hdata)
##
}
\references{
Prabhash et al(2016) <doi:10.21307/stattrans-2016-046>
}
\seealso{
wbysmv, lgnbymv, lgstbymvs
}
\author{
Atanu Bhattacharjee, Gajendra Kumar Vishwakarma and Pragya Kumari
}
