% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-irreflexivity.R
\name{rel_is_irreflexive}
\alias{rel_is_irreflexive}
\title{Irreflexive Binary Relations}
\usage{
rel_is_irreflexive(R)
}
\arguments{
\item{R}{an object coercible to a 0-1 (logical) square matrix,
representing a binary relation on a finite set.}
}
\value{
\code{rel_is_irreflexive} returns
a single logical value.
}
\description{
A binary relation \eqn{R} is \emph{irreflexive}
(or antireflexive), iff
for all \eqn{x} we have \eqn{\neg xRx}{!xRx}.
}
\details{
\code{rel_is_irreflexive} finds out if a given binary relation
is irreflexive. The function just checks whether all elements
on the diagonal of \code{R} are zeros,
i.e., it has \eqn{O(n)} time complexity,
where \eqn{n} is the number of rows in \code{R}.
Missing values on the diagonal may result in \code{NA}.

When dealing with a graph's loops,
i.e., elements related with themselves, you may be interested
in finding a reflexive closure,
see \code{\link{rel_closure_reflexive}},
or a reflexive reduction,
see \code{rel_reduction_reflexive}.
}
\seealso{
Other binary_relations: \code{\link{check_comonotonicity}},
  \code{\link{pord_nd}}, \code{\link{pord_spread}},
  \code{\link{pord_weakdom}}, \code{\link{rel_graph}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_cyclic}},
  \code{\link{rel_is_reflexive}},
  \code{\link{rel_is_symmetric}},
  \code{\link{rel_is_total}},
  \code{\link{rel_is_transitive}},
  \code{\link{rel_reduction_hasse}}
}
\concept{binary_relations}
