% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstFrost.R
\name{firstFrost}
\alias{firstFrost}
\title{Mean first frost day}
\usage{
firstFrost(mn, dates, iniday = "07-01", endday = "06-30",
  type = "doy", thres = 0)
}
\arguments{
\item{mn}{vector of daily minimum temperature series.}

\item{dates}{vector of dates corresponding with daily temprature series}

\item{iniday}{first day of the year ("dd-mm") when frost occurrence will be considered.}

\item{endday}{last day of the year ("dd-mm") when frost occurrence will be considered.}

\item{type}{type of output. It can be "doy" for day of the year (julian day) or "date" for data format ("dd-mm").}

\item{thres}{temperature threshold considered to trigger frost occurrence (0 by default).}
}
\value{
Depending on argument type, the output will be a numeric vector of julian days (type = "doy") or a vector of characters with dates (type = "date").
}
\description{
Calculates the first frost day within a predefined period.
}
\details{
The function is able to span over years. If the argument "enddate" is a date earlier than "inidate", the considered period will cover from "inidate" to the end of the year and from the beginning of the next year to "enddate".
}
\examples{


firstFrost(mn = daily_tmin,
            dates = seq.Date(as.Date('1981-01-01'),
                             as.Date('2010-12-31'), by ='day'),
            iniday = '07-01',
            endday = '06-30',
            type = 'doy')
}
