% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahn_main.R
\name{predict.ahn}
\alias{predict.ahn}
\title{predict}
\usage{
\method{predict}{ahn}(x, new_data, ...)
}
\arguments{
\item{x}{an object of class "\code{ahn}" produced from the \link{fit} function.}

\item{new_data}{a data frame with the inputs to be predicted.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
predicted output values for inputs in \code{new_data}.
}
\description{
Function to simulate a trained Artificial Hydrocarbon Network.
}
\examples{
\dontrun{
# Create data
x <- 2 * runif(1000) - 1;
x <- sort(x)

y <- (x < 0.1) * (0.05 * runif(100) + atan(pi*x)) +
    (x >= 0.1 & x < 0.6) * (0.05 * runif(1000) + sin(pi*x)) +
    (x >= 0.6) * (0.05 * runif(1000) + cos(pi*x))

# Create Sigma list
Sigma <- list(X = data.frame(x = x), Y = data.frame(y = y))

# Train AHN
ahn <- fit(Sigma, 5, 0.01, 500)

# Test AHN
X <- data.frame(x = x)
ysim <- predict(ahn, X)
}

}
