% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R, R/table.R
\name{Analyze}
\alias{Analyze}
\alias{AnalyzeTable}
\alias{PruneByCutoff}
\alias{PruneLevels}
\title{Analyze your AHP model}
\usage{
Analyze(ahpTree, decisionMaker = "Total", variable = c("weightContribution",
  "priority", "score"), sort = c("priority", "totalPriority", "orig"),
  pruneFun = function(node, decisionMaker) TRUE)

AnalyzeTable(ahpTree, decisionMaker = "Total",
  variable = c("weightContribution", "priority", "score"),
  sort = c("priority", "totalPriority", "orig"), pruneFun = function(node,
  decisionMaker) TRUE, weightColor = "honeydew3",
  consistencyColor = "wheat2", alternativeColor = "thistle4")

PruneByCutoff(node, decisionMaker, minWeight = 0)

PruneLevels(node, decisionMaker, levelsToPrune = 0)
}
\arguments{
\item{ahpTree}{the calculated AHP \code{data.tree}}

\item{decisionMaker}{the name of the decision maker. The default returns the joint decision.}

\item{variable}{the variable to display, i.e. either weightContribution (the default), priority, or score}

\item{sort}{sort either by priority according to the decision maker (the default), by totalPriority, or as originally specified (orig)}

\item{pruneFun}{use this to filter the what rows are shown in the analysis
\code{pruneFun} must be a function taking a \code{Node} as its first argument, and the \code{decisionMaker} as its second
argument. The default (\code{NULL}) returns the full AHP tree}

\item{weightColor}{The name of the color to be used to emphasize weights of categories. See \code{color} for a list of possible colors.}

\item{consistencyColor}{The name of the color to be used to highlight bad consistency}

\item{alternativeColor}{The name of the color used to highlight big contributors to alternative choices.}

\item{node}{the \code{Node}}

\item{minWeight}{prunes the nodes whose weightContribution is smaller than the minWeight}

\item{levelsToPrune}{cuts the \code{n} hightest levels of the ahp tree}
}
\value{
Analyze returns a \code{data.frame} containing the contribution of each criteria

AnalyzeTable returns a \code{\link{formattable}} data.frame object which, in most environments, will be displayed as an HTML table

the Prune methods must return \code{TRUE} for nodes to be kept, \code{FALSE} for nodes to be pruned
}
\description{
Converts the calculated AHP tree into a \code{data.frame} or an HTML table, containing all the weight contributions or
priorities to/of the overall decision. You can also sort and filter the output.

Displays the AHP analysis in form of an html table, with gradient
colors and nicely formatted.
}
\examples{
ahpFile <- system.file("extdata", "car.ahp", package="ahp")
carAhp <- Load(ahpFile)
Calculate(carAhp)
Analyze(
   carAhp, 
   pruneFun = function(x, decisionMaker) {
     PruneLevels(x, decisionMaker, 1) && PruneByCutoff(x, decisionMaker, minWeight = 0.05)
   }
)
   
   
ahpFile <- system.file("extdata", "vacation.ahp", package="ahp")
vacationAhp <- Load(ahpFile)
Calculate(vacationAhp)
AnalyzeTable(
   vacationAhp,
   decisionMaker = "Kid",
   variable = "score",
   sort = "totalPriority"
)

}
