% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIFETransformerMaker.R
\name{AIFETransformerMaker}
\alias{AIFETransformerMaker}
\title{\code{R6} class for transformer creation}
\description{
This class was developed to make the creation of transformers easier for users. Pass the transformer's
type to the \code{make} method and get desired transformer. Now run the \code{create} or/and \code{train} methods of the new
transformer.

The already created \link{aife_transformer_maker} object of this class can be used.

See p.3 Transformer Maker in
\href{https://fberding.github.io/aifeducation/articles/transformers.html}{Transformers for Developers} for details.

See \link{.AIFEBaseTransformer} class for details.
}
\examples{
# Create transformer maker
tr_maker <- AIFETransformerMaker$new()

# Use 'make' method of the 'tr_maker' object
# Pass string with the type of transformers
# Allowed types are "bert", "deberta_v2", "funnel", etc. See aifeducation::AIFETrType list
my_bert <- tr_maker$make("bert")

# Or use elements of the 'aifeducation::AIFETrType' list
my_longformer <- tr_maker$make(AIFETrType$longformer)

# Run 'create' or 'train' methods of the transformer in order to create a
# new transformer or train the newly created one, respectively
# my_bert$create(...)
# my_bert$train(...)

# my_longformer$create(...)
# my_longformer$train(...)

}
\seealso{
Other Transformer: 
\code{\link{AIFETrType}},
\code{\link{aife_transformer_maker}}
}
\concept{Transformer}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AIFETransformerMaker-make}{\code{AIFETransformerMaker$make()}}
\item \href{#method-AIFETransformerMaker-clone}{\code{AIFETransformerMaker$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AIFETransformerMaker-make"></a>}}
\if{latex}{\out{\hypertarget{method-AIFETransformerMaker-make}{}}}
\subsection{Method \code{make()}}{
Creates a new transformer with the passed type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AIFETransformerMaker$make(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{\code{string} A type of the new transformer. Allowed types are bert, roberta, deberta_v2, funnel, longformer, mpnet. See
\link{AIFETrType} list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If success - a new transformer, otherwise - an error (passed type is invalid).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AIFETransformerMaker-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AIFETransformerMaker-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AIFETransformerMaker$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
