% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{to_categorical_c}
\alias{to_categorical_c}
\title{Transforming classes to one-hot encoding}
\usage{
to_categorical_c(class_vector, n_classes)
}
\arguments{
\item{class_vector}{\code{vector} containing integers for every class. The
integers must range from 0 to n_classes-1.}

\item{n_classes}{\code{int} Total number of classes.}
}
\value{
Returns a \code{matrix} containing the binary representation for
every class.
}
\description{
Function written in C++ transforming a vector of classes (int) into
a binary class matrix.
}
\seealso{
Other Utils Developers: 
\code{\link{auto_n_cores}()},
\code{\link{create_object}()},
\code{\link{create_synthetic_units_from_matrix}()},
\code{\link{generate_id}()},
\code{\link{get_n_chunks}()},
\code{\link{get_synthetic_cases_from_matrix}()},
\code{\link{matrix_to_array_c}()},
\code{\link{tensor_to_matrix_c}()}
}
\concept{Utils Developers}
