% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateSupervisor.R
\name{CreateSupervisor}
\alias{CreateSupervisor}
\title{Creation of a Supervisor for handling regulation in a model}
\usage{
CreateSupervisor(InputsModel, TimeStep = 1L)
}
\arguments{
\item{InputsModel}{[object of type \code{GRiwrmInputsModel}] inputs of the model}

\item{TimeStep}{\link{numeric} number of time steps between each supervision}
}
\value{
A \code{Supervisor} object which is an \link{environment} containing all the necessary variables to run a supervised simulation, such as:
\itemize{
\item \code{DatesR} \link{POSIXct}: vector of date from \code{InputsModel}
\item \code{InputsModel}: a copy of \code{InputsModel} provided by \link{CreateInputsModel.GRiwrm}
\item \code{griwrm}: a copy of \code{griwrm} provided by \link{CreateGRiwrm}
\item \code{Controllers} \link{list}: list of the controllers used in the supervised simulation (See \link{CreateController})
\item some internal state variables updated during simulation (\code{ts.index}, \code{ts.previous}, \code{ts.date}, \code{ts.index0}, \code{controller.id})
}
}
\description{
Creation of a Supervisor for handling regulation in a model
}
\examples{
data(Severn)
nodes <- Severn$BasinsInfo[, c("gauge_id", "downstream_id", "distance_downstream", "area")]
nodes$model <- "RunModel_GR4J"
griwrm <- CreateGRiwrm(nodes,
                 list(id = "gauge_id",
                      down = "downstream_id",
                      length = "distance_downstream"))
BasinsObs <- Severn$BasinsObs
DatesR <- BasinsObs[[1]]$DatesR
PrecipTot <- cbind(sapply(BasinsObs, function(x) {x$precipitation}))
PotEvapTot <- cbind(sapply(BasinsObs, function(x) {x$peti}))
Qobs <- cbind(sapply(BasinsObs, function(x) {x$discharge_spec}))
Precip <- ConvertMeteoSD(griwrm, PrecipTot)
PotEvap <- ConvertMeteoSD(griwrm, PotEvapTot)
InputsModel <- CreateInputsModel(griwrm, DatesR, Precip, PotEvap, Qobs)
sv <- CreateSupervisor(InputsModel)
}
