% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{airports_around}
\alias{airports_around}
\title{Lookup airports near specified coordinates}
\usage{
airports_around(lat, lon, distance = 100)
}
\arguments{
\item{lat}{Latitude in decimal degrees}

\item{lon}{Longitude in decimal degrees}

\item{distance}{Distance boundary for nearest airport lookup in kilometres}
}
\value{
A tibble of airports that fall within the specified range of specified location
}
\description{
A function that returns details of all airports within a user-specified distance of an input coordinate location. Takes as input a longitude and latitude argument.
}
\examples{
airports_around(-123,49.2)

# Or with a user specified distance in kilometres
airports_around(-123, 49.2, distance = 200)
}
