% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irtmodel.R
\name{irtmodel}
\alias{irtmodel}
\title{Fits a polytomous IRT model.}
\usage{
irtmodel(dat, ncycle = NULL, vpara = TRUE)
}
\arguments{
\item{dat}{The performance data in a matrix or dataframe.}

\item{ncycle}{The number of cycles for \code{mirt}. The default is 500.}

\item{vpara}{It \code{TRUE} the \code{verbose} parameter for the \code{mirt} would be set to true.}
}
\value{
A list with the following components:
\item{\code{model}}{The IRT model using the R package \code{mirt}.  }
\item{\code{anomalous}}{A binary sequence corresponding to the algorithms. It is set to 1 if an algorithm is anomalous. Otherwise it is set to 0.  }
 \item{\code{stability}}{A binary sequence corresponding to the algorithms. It is set to 1 if an algorithm is anomalous. Otherwise it is set to 0.  }
}
\description{
This function fits a polytomous Item Response Theory (IRT) model to the algorithm performance data.
}
\examples{
set.seed(1)
x1 <- sample(1:5, 100, replace = TRUE)
x2 <- sample(1:5, 100, replace = TRUE)
x3 <- sample(1:5, 100, replace = TRUE)
X <- cbind.data.frame(x1, x2, x3)
mod <- irtmodel(X)
}
