% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{plotAbundance}
\alias{plotAbundance}
\title{Plots a clonal abundance distribution}
\usage{
plotAbundance(data, colors = NULL, main_title = "Rank Abundance",
  legend_title = NULL, xlim = NULL, ylim = NULL, silent = FALSE, ...)
}
\arguments{
\item{data}{data.frame returned by \link{estimateAbundance}.}

\item{colors}{named character vector whose names are values in the 
\code{group} column of \code{data} and whose values are 
colors to assign to those group names.}

\item{main_title}{string specifying the plot title.}

\item{legend_title}{string specifying the legend title.}

\item{xlim}{numeric vector of two values specifying the 
\code{c(lower, upper)} x-axis limits.}

\item{ylim}{numeric vector of two values specifying the 
\code{c(lower, upper)} y-axis limits.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A \code{ggplot} object defining the plot.
}
\description{
\code{plotAbundance} plots the results from estimating the complete clonal relative 
abundance distribution. The distribution is plotted as a log rank abundance 
distribution.
}
\examples{
# Estimate abundance by sample and plot
abund <- estimateAbundance(ExampleDb, "SAMPLE", nboot=100)
plotAbundance(abund)

}
\seealso{
See \link{estimateAbundance} for generating the input abundance distribution.
Plotting is performed with \link{ggplot}.
}

