% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFewestLineMap.R
\name{reduceToFewest}
\alias{reduceToFewest}
\title{Reduce an All-line Map to two types of fewest-line maps}
\usage{
reduceToFewest(allLineMap)
}
\arguments{
\item{allLineMap}{An AllLineShapeGraph}
}
\value{
A list with two fewest-line axial ShapeGraphs
}
\description{
Reduce an All-line Map to two types of fewest-line maps
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeMap <- as(sfMap[, vector()], "ShapeMap")
allLineMap <- makeAllLineMap(
  shapeMap,
  seedX = 3.01,
  seedY = 6.7
)
reduceToFewest(allLineMap)
}
