% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnr_simple.r
\name{gnr_simple}
\alias{gnr_simple}
\title{Wrapper function for taxize::gnr_resolve()
checks species names against a variety of online databases
supports fuzzy partial matching}
\usage{
gnr_simple(
  name,
  sourceid = NULL,
  topscore = TRUE,
  numhits = TRUE,
  canonical = TRUE,
  with_context = TRUE,
  ...
)
}
\arguments{
\item{name}{character string binomial scientific name to resolve}

\item{sourceid}{integer with data source id from taxize::gnr_datasources()}

\item{topscore}{boolean. Should the best match be returned based on score?}

\item{numhits}{boolean. Should the best match be returned based on 
the number of sources with a match?}

\item{canonical}{If TRUE, names do not include authorship or date}

\item{with_context}{If TRUE, Match scores are weighted for taxonomic consistency}

\item{...}{Other parameters passed to taxize::gnr_resolve()}
}
\value{
new data.frame with name matches, column indicating an exact match,
scores, and number of hits (matches) from different data sources in gnr_resolve()
}
\description{
Provides convienent output with a single result, using a variety 
of criteria for the best match
}
\examples{
#use taxize::gnr_datasources() to see all possible data sources for name checking.
name<-"Aphanazomenon flos-aquae"
#sourceid=3 for ITIS database,195 for Algaebase
gnr_simple(name,sourceid=3) #search for ITIS matches
gnr_simple(name,sourceid=NULL) #search for matches from any source
}
