% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_mat.R
\name{date_mat}
\alias{date_mat}
\title{Transform a phytoplankton timeseries into a matrix of abundances for ordination}
\usage{
date_mat(
  phyto.df,
  abundance.var = "biovol_um3_ml",
  summary.type = "abundance",
  taxa.name = "phyto_name",
  date.name = "date_dd_mm_yy",
  format = "\%d-\%m-\%y",
  time.agg = c("day", "month", "year", "monthyear"),
  fun = mean_naomit
)
}
\arguments{
\item{phyto.df}{Name of data.frame object}

\item{abundance.var}{Character string: field containing abundance data.
Can be NA if the dataset only contains a species list for each sampling date.}

\item{summary.type}{'abundance' for a matrix of aggregated abundance,'presence.absence'
for 1 (present) and 0 (absent).}

\item{taxa.name}{Character string: field containing taxonomic identifiers.}

\item{date.name}{Character string: field containing date.}

\item{format}{Character string: POSIX format string for formatting date column.}

\item{time.agg}{Character string: time interval for aggregating abundance. default is day.}

\item{fun}{function for aggregation. default is mean, excluding NA's.}
}
\value{
A matrix of phytoplankton abundance, with taxa in rows and time in columns.
        If time.agg = 'monthyear', returns a 3dimensional matrix (taxa,month,year).
        If abundance.var = NA, matrix cells will be 1 for present, 0 for absent
}
\description{
Transform a phytoplankton timeseries into a matrix of abundances for ordination
}
\examples{
data(lakegeneva)
#example dataset with 50 rows

geneva.mat1<-date_mat(lakegeneva,time.agg='month',summary.type='presence.absence')
geneva.mat2<-date_mat(lakegeneva,time.agg='month',summary.type='abundance')

geneva.mat1
geneva.mat2
}
