% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/signal.R
\docType{methods}
\name{signal_shift}
\alias{signal_shift}
\alias{signal_shift-method}
\alias{signal_shift,numeric,numeric-method}
\alias{signal_shift,ANY,missing-method}
\title{Shift the X Scale}
\usage{
signal_shift(x, y, lag, ...)

\S4method{signal_shift}{numeric,numeric}(x, y, lag)

\S4method{signal_shift}{ANY,missing}(x, lag)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{lag}{A \code{\link{numeric}} vector specifying the offset.}

\item{...}{Currently not used.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Shifts the \code{x} scale by a given value.
}
\examples{
## X-ray diffraction
data("XRD")

## Plot spectrum
plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")

## Shift by one degree
XRD_offset <- signal_shift(XRD, lag = 1)
lines(XRD_offset, type = "l", col = "red")
}
\seealso{
Other signal processing methods: 
\code{\link{signal_bind}()},
\code{\link{signal_correct}()},
\code{\link{signal_drift}()},
\code{\link{signal_mean}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{signal processing methods}
