% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/peaks.R
\docType{methods}
\name{peaks_fwhm}
\alias{peaks_fwhm}
\alias{peaks_fwhm-method}
\alias{peaks_fwhm,numeric,numeric-method}
\alias{peaks_fwhm,ANY,missing-method}
\title{Half-Width at Half-Maximum}
\usage{
peaks_fwhm(x, y, ...)

\S4method{peaks_fwhm}{numeric,numeric}(x, y, center)

\S4method{peaks_fwhm}{ANY,missing}(x, center)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{center}{A \code{\link{numeric}} value giving the peak position in \code{x} units.}
}
\value{
A \code{\link{numeric}} value.
}
\description{
Estimates the Half-Width at Half-Maximum (FWHM) for a given peak.
}
\details{
It tries to get the smallest possible estimate.
}
\examples{
## X-ray diffraction
data("XRD")

## 4S Peak Filling baseline
baseline <- baseline_peakfilling(XRD, n = 10, m = 5, by = 10, sparse = TRUE)

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
lines(baseline, type = "l", col = "red")

## Correct baseline
XRD <- signal_drift(XRD, lag = baseline, subtract = TRUE)

## Find peaks
peaks <- peaks_find(XRD, SNR = 3, m = 11)

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
lines(peaks, type = "p", pch = 16, col = "red")
abline(h = attr(peaks, "noise"), lty = 2) # noise threshold

## Half-Width at Half-Maximum
x <- seq(-4, 4, length = 1000)
y <- dnorm(x)

peaks_fwhm(x, y, center = 0) # Expected: 2 * sqrt(2 * log(2))
}
\seealso{
Other peaks detection methods: 
\code{\link{peaks_find}()}
}
\author{
N. Frerebeau
}
\concept{peaks detection methods}
