% Generated by roxygen2 (4.0.2): do not edit by hand
\name{alm_ids}
\alias{alm_ids}
\title{Retrieve PLoS article-level metrics (ALM).}
\usage{
alm_ids(doi = NULL, pmid = NULL, pmcid = NULL, mendeley_uuid = NULL,
  info = "totals", source = NULL, key = NULL, total_details = FALSE,
  sum_metrics = NULL, sleep = 0,
  url = "http://alm.plos.org/api/v5/articles", ...)
}
\arguments{
\item{doi}{Digital object identifier for an article in PLoS Journals (character)}

\item{pmid}{PubMed object identifier (numeric)}

\item{pmcid}{PubMed Central object identifier (numeric)}

\item{mendeley_uuid}{Mendeley object identifier (character)}

\item{info}{One of totals, summary, or detail (default totals + sum_metrics data in a list).
     Not specifying anything (the default) returns data.frame of totals across
     data providers. (character). \code{info='detail'} returns all possible data, including slots
   for info, signposts, totals, and sum_metrics (see the sum_metrics parameter below).
IMPORTANT: note, however, that you can only get by day metrics for articles published since
May 2014.}

\item{source}{(character) Name of source to get ALM information for. One source only.
You can get multiple sources via a for loop or lapply-type call.}

\item{key}{your PLoS API key, either enter, or loads from .Rprofile (character)}

\item{total_details}{If FALSE (the default) the standard totals data.frame is
returned; if TRUE, the totals data is in a wide format with more details
about the paper, including publication date, title, etc. If you set this
to TRUE, the output should no longer with with \code{\link{alm_plot}}.}

\item{sum_metrics}{Just like the output you get from setting info='totals', you can
get summary metrics by day (sum_metrics='day'), month (sum_metrics='month'),
or year (sum_metrics='year'). IMPORTANT: note that you can only get by day metrics for
articles published since May 2014.}

\item{sleep}{Set a sleep time (in seconds). Only used for large calls where you may be in danger
of upsetting the server gods, can you say 504 error?}

\item{url}{API endpoint, defaults to http://alm.plos.org/api/v5/articles (character)}

\item{...}{optional additional curl options (debugging tools mostly)}
}
\value{
PLoS altmetrics as data.frame's.
}
\description{
This is the main function to search the PLoS ALM (article-level metrics) API.
See details for more information.
}
\details{
You can only supply one of the parmeters doi, pmid, pmcid, and mendeley; and you
must supply one of them. Query for as many articles at a time as you like. Though queries
are broken up in to smaller bits of 50 identifiers at a time. If you supply days, months and/or
year parameters, days takes precedence over months and year.
}
\examples{
\dontrun{
# The default call with either doi, pmid, pmcid, or mendeley without specifying
# an argument for info
alm_ids(doi="10.1371/journal.pone.0029797")

# Details for a single DOI
out <- alm_ids(doi='10.1371/journal.pone.0029797', info='detail')
out
## totals
out$data$info
## history
out$data$sum_metrics

# A single PubMed ID (pmid)
alm_ids(pmid=22590526)

# A single PubMed Central ID (pmcid)
alm_ids(pmcid=212692, info='summary')

# A single Mendeley UUID (mendeley)
alm_ids(mendeley_uuid="1d7e7f09-c59b-364b-8c39-a7686f0e9fa0")

# Provide more than one DOI
dois <- c('10.1371/journal.pone.0001543','10.1371/journal.pone.0040117',
		'10.1371/journal.pone.0029797','10.1371/journal.pone.0039395')
out <- alm_ids(doi=dois)
out$data[[1]] # get data for the first DOI

# Search for DOI's, then feed into alm
library('rplos')
dois <- searchplos(q='evolution', fl='id',
   fq=list('-article_type:correction','doc_type:full'), limit = 150)
out <- alm_ids(doi=dois$data$id)
lapply(out, head)

alm_ids(dois$data$id[1:5], source = "facebook")

sources <- c("facebook","twitter","mendeley","reddit","scopus","wikipedia")
lapply(sources, function(x) alm_ids(dois$data$id[1:5], source = x))

# Provide more than one pmid
pmids <- c(19300479, 19390606, 19343216)
out <- alm_ids(pmid=pmids)
out[[3]] # get data for the third pmid

# Getting data for a specific source
alm_ids(doi='10.1371/journal.pone.0035869', source='mendeley')
alm_ids(doi='10.1371/journal.pone.0035869', source='twitter')
alm_ids(doi='10.1371/journal.pone.0035869', source='counter', info='detail')
## fails if more than one source given
alm_ids(doi='10.1371/journal.pone.0035869', source=c('twitter','facebook'))

# Get detailed totals output
alm_ids(doi='10.1371/journal.pone.0035869', total_details=TRUE)

# Get summary metrics by day
alm_ids(doi='10.1371/journal.pone.0036240', sum_metrics='day')

# Get summary metrics by month
alm_ids(doi='10.1371/journal.pone.0036240', sum_metrics='month')

# Get summary metrics by year
alm_ids(doi='10.1371/journal.pone.0036240', sum_metrics='year')

# Curl debugging
library('httr')
alm_ids(doi="10.1371/journal.pone.0029797", config=verbose())
dois <- c('10.1371/journal.pone.0001543','10.1371/journal.pone.0040117',
 	'10.1371/journal.pone.0029797','10.1371/journal.pone.0039395')
alm_ids(doi=dois, config=verbose())
}
}
\references{
See a tutorial/vignette for alm at
\url{http://ropensci.org/tutorials/alm_tutorial.html}
}
\seealso{
\code{\link{alm_plot}}
}

