% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_job_output}
\alias{get_job_output}
\title{Get Job Output}
\usage{
get_job_output(job, gallery = get_gallery(), quiet = FALSE)
}
\arguments{
\item{job}{An completed Alteryx job returned from \code{get_app_jobs}}

\item{gallery}{URL for your Alteryx Gallery}

\item{quiet}{Set to \code{TRUE} to ignore the warnings of skipped, invalid
outputs}
}
\value{
A \code{list} containing a \code{data.frame} for each valid output
of an Alteryx app. Valid means that the output can be converted as explained
in the WARNING section.
}
\description{
If an Alteryx app includes one or more output tools inside the
application, the output will be available for download once the job is
complete.

Use \code{get_job_output} to get the job outputs as a \code{data.frame}
}
\section{WARNING}{

In order to retrieve the results for a job as a \code{data.frame}, the
from the Alteryx app that is published to your gallery must have an output
format of csv or yxdb. Otherwise, it cannot be properly converted. If you
have multiple outputs, some of which cannot be converted, this function will
issue a warning and skip the invalid outputs. Use \code{queit = TRUE} to
skip the outputs without warning.
}

