% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_auxiliary.R
\name{process_conformity}
\alias{process_conformity}
\title{Check input assumptions}
\usage{
process_conformity(locs = NULL, check_time = FALSE, locs_epsg = "EPSG:4326")
}
\arguments{
\item{locs}{Data. \link[sf:st_as_sf]{sf},
\link[terra:vect]{SpatVector}, or \link{data.frame}}

\item{check_time}{logical(1). Whether \code{"time"} exists in column names.}

\item{locs_epsg}{character(1). \code{"{authority}:{code}"} or
Well-Known Text format for coordinate reference system definition.}
}
\value{
a \code{SpatVector} object
}
\description{
Check if all of \code{"lon"}, \code{"lat"}, and \code{"time"}
(only if \code{check_time = TRUE}) then convert inputs into a
\code{SpatVector} object.
}
\author{
Insang Song
}
