% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.min.max.int.ext}
\alias{intFun.min.max.int.ext}
\title{Range and interval for color bar legend}
\usage{
intFun.min.max.int.ext(x)
}
\arguments{
\item{x}{An R object}
}
\value{
Minimum, maximum, and interval value for color bar legend
}
\description{
This function returns the minimum, maximum, and interval value
that can be used to define a color bar legend. The minimum and maximum values are computed for the first and 99th percentile.
}
\examples{

library(raster)
library(classInt)
# create a raster object
data <- runif(100,-23,864)
data <- matrix(data, ncol=10)
data <- raster::raster(data)
# Get min, max, and interval for color bar legend
mmi <- intFun.min.max.int.ext(data)

}
\keyword{internal}
