% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.case-reports.R
\name{amber.case_report_form}
\alias{amber.case_report_form}
\title{Get a case report form}
\usage{
amber.case_report_form(
  amber,
  id,
  study = NULL,
  form = NULL,
  revision = NULL,
  query = list()
)
}
\arguments{
\item{amber}{An Amber object}

\item{id}{Case report form's name or identifier}

\item{study}{Study identifier (name or id), optional.}

\item{form}{Form's name or identifier}

\item{revision}{Revision number, optional, default is NULL (means that the
case report form uses the latest form revision).}

\item{query}{The search query, to desambiguate form lookup by name}
}
\value{
A case report form object as a named list
}
\description{
Get a case report form by its name or identifier and its revision number (if any).
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")
amber.case_report_form(a, id = "Adult trauma - baseline", form = "Adult trauma", revision = 10)
amber.case_report_form(a, id = "61e69a22fea2df2f3108b508")
amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaigns}()},
\code{\link{amber.campaign}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.forms}()},
\code{\link{amber.form}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.participants}()},
\code{\link{amber.participant}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
