% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ame.R
\name{ame}
\alias{ame}
\title{AME model fitting routine}
\usage{
ame(Y, Xdyad=NULL, Xrow=NULL, Xcol=NULL, rvar = !(model=="rrl") ,
cvar = TRUE,  dcor = !symmetric, nvar=TRUE, R = 0, model="nrm",
intercept=!is.element(model,c("rrl","ord")),
symmetric=FALSE,
odmax=rep(max(apply(Y>0,1,sum,na.rm=TRUE)),nrow(Y)), seed = 1, nscan =
10000, burn = 500, odens = 25, plot=TRUE, print = TRUE, gof=TRUE)
}
\arguments{
\item{Y}{an n x n square relational matrix of relations. See model below for
various data types.}

\item{Xdyad}{an n x n x pd array of covariates}

\item{Xrow}{an n x pr matrix of nodal row covariates}

\item{Xcol}{an n x pc matrix of nodal column covariates}

\item{rvar}{logical: fit row random effects (asymmetric case)?}

\item{cvar}{logical: fit column random effects (asymmetric case)?}

\item{dcor}{logical: fit a dyadic correlation (asymmetric case)?}

\item{nvar}{logical: fit nodal random effects (symmetric case)?}

\item{R}{integer: dimension of the multiplicative effects (can be zero)}

\item{model}{character: one of "nrm","bin","ord","cbin","frn","rrl" - see
the details below}

\item{intercept}{logical: fit model with an intercept?}

\item{symmetric}{logical: Is the sociomatrix symmetric by design?}

\item{odmax}{a scalar integer or vector of length n giving the maximum
number of nominations that each node may make - used for "frn" and "cbin"
models}

\item{seed}{random seed}

\item{nscan}{number of iterations of the Markov chain (beyond burn-in)}

\item{burn}{burn in for the Markov chain}

\item{odens}{output density for the Markov chain}

\item{plot}{logical: plot results while running?}

\item{print}{logical: print results while running?}

\item{gof}{logical: calculate goodness of fit statistics?}
}
\value{
\item{BETA}{posterior samples of regression coefficients}
\item{VC}{posterior samples of the variance parameters}
\item{APM}{posterior mean of additive row effects a} \item{BPM}{posterior
mean of additive column effects b} \item{U}{posterior mean of multiplicative
row effects u} \item{V}{posterior mean of multiplicative column effects v (asymmetric case)}
\item{UVPM}{posterior mean of UV (asymmetric case)}
\item{ULUPM}{posterior mean of ULU (symmetric case)}
\item{L}{posterior mean of L (symmetric case)}
 \item{EZ}{estimate of expectation of Z
matrix} \item{YPM}{posterior mean of Y (for imputing missing values)}
\item{GOF}{observed (first row) and posterior predictive (remaining rows)
values of four goodness-of-fit statistics}
}
\description{
An MCMC routine providing a fit to an additive and multiplicative effects
(AME) regression model to relational data of various types
}
\details{
This command provides posterior inference for parameters in AME models of
relational data, assuming one of six possible data types/models:

"nrm": A normal AME model.

"bin": A binary probit AME model.

"ord": An ordinal probit AME model. An intercept is not identifiable in this
model.

"cbin": An AME model for censored binary data.  The value of 'odmax'
specifies the maximum number of links each row may have.

"frn": An AME model for fixed rank nomination networks. A higher value of
the rank indicates a stronger relationship. The value of 'odmax' specifies
the maximum number of links each row may have.

"rrl": An AME model based on the row ranks. This is appropriate if the
relationships across rows are not directly comparable in terms of scale. An
intercept, row random effects and row regression effects are not estimable
for this model.
}
\examples{
data(YX_frn)
fit<-ame(YX_frn$Y,YX_frn$X,burn=5,nscan=5,odens=1,model="frn")
# you should run the Markov chain much longer than this
}
\author{
Peter Hoff
}

