% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_list_metadata.R
\name{amf_list_metadata}
\alias{amf_list_metadata}
\title{Get metadata availability}
\usage{
amf_list_metadata(site_set = NULL, group_only = TRUE)
}
\arguments{
\item{site_set}{A scalar or vector of character specifying the target
AmeriFlux Site ID (CC-Sss). If not specified, it returns all sites.}

\item{group_only}{Logical (TRUE/FALSE). Should it return availability for
BADM variable groups or variables? BADM Groups contain Variables that
describe related metadata or an observation with related metadata.}
}
\value{
A data frame of data variable availability (per year) for selected
 AmeriFlux sites. The first column contains the SITE ID. The remaining
 columns contains the number of entries for a variable or a variable group,
 with column names specifying the BADM variable or group names.
\itemize{
  \item Site_ID - Six character site identifier (CC-Sss)
  \item ...
  }
}
\description{
This function obtains the metadata (i.e., BADM) availability
for all or selected AmeriFlux sites. See AmeriFlux page
\url{https://ameriflux.lbl.gov/data/badm/} for details about the BADM.
}
\examples{
\dontrun{
# obtain the metadata availability for all sites, at variable group levels
metadata_aval <- amf_list_metadata()

# obtain the metadata availability for selected sites, at variable levels
metadata_aval <- amf_list_metadata(site_set = c("US-CRT","US-WPT"),
group_only = FALSE)
}
}
