% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_var_info.R
\name{amf_var_info}
\alias{amf_var_info}
\title{Get variable information}
\usage{
amf_var_info(out_dir = tempdir(), verbose = TRUE)
}
\arguments{
\item{out_dir}{The output directory  (default = tempdir())}

\item{verbose}{Logical, whether to show download progress (TRUE/FALSE)}
}
\value{
A data frame of measurement height data for all AmeriFlux sites
#' \itemize{
  \item Site_ID - Six character site identifier (CC-Sss)
  \item Variable - Variable name of the data included in the BASE file
  \item Start_Date - Date when the information first applies
  \item Height - Distance above the ground surface in meters
  \item Instrument_Model - Instrument model used to collect the data variable
  \item Instrument_Model2 - A second instrument model used to collect
   the data variable
  \item Comment - Additional information provided by the site team
  \item BASE_Version - The most recent BASE data product version number for
  which the information applies
  }
}
\description{
This function obtains the measurement height metadata for the
AmeriFlux BASE data product. See AmeriFlux page
\url{https://ameriflux.lbl.gov/data/measurement-height/} for details.
}
\examples{
\dontrun{
# download the measurement height data for all sites
var_info <- amf_var_info()
}
}
