% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{flag_duplicates}
\alias{flag_duplicates}
\alias{flag_duplicates.track_xyt}
\title{Flag Low Quality Duplicates}
\usage{
flag_duplicates(x, gamma, time_unit = "mins", DOP = "dop", ...)

\method{flag_duplicates}{track_xyt}(x, gamma, time_unit = "mins", DOP = "dop", ...)
}
\arguments{
\item{x}{\verb{[track_xyt]} A \code{track_xyt} object.}

\item{gamma}{\verb{[numeric or Period]} The temporal tolerance defining duplicates.
See details below. If \code{numeric}, its units are defined by \code{time_unit}. If
\code{Period}, \code{time_unit} is ignored.}

\item{time_unit}{\verb{[character]} Character string giving time unit for \code{gamma}.
Should be \code{"secs"}, \code{"mins"}, or \code{"hours"}. Ignored if \verb{class(gamma) == "Period".}}

\item{DOP}{\verb{[character]} A character string giving the name of the column
containing the dilution of precision (DOP) data. See details below.}

\item{...}{Addtional arguments. None currently implemented.}
}
\value{
Returns \code{x} (a \code{track_xyt}) with a flagging column added (\code{x$duplicate_}).
}
\description{
Flags locations with duplicate timestamps by DOP and distance
}
\details{
Locations are considered duplicates if their timestamps are within
\code{gamma} of each other. However, the function runs sequentially through the
track object, so that only timestamps after the focal point are flagged as
duplicates (and thus removed from further consideration). E.g., if
\code{gamma = minutes(5)}, then all locations with timestamp within 5 minutes
after the focal location will be considered duplicates.

When duplicates are found, (1) the location with the lowest dilution of precision
(given by \code{DOP} column) is kept. If there are multiple duplicates with equally
low DOP, then (2) the one closest in space to previous location is kept. In
the event of exact ties in DOP and distance, (3) the first location is kept.
This is unlikely unless there are exact coordinate duplicates.

In the case that the first location in a trajectory has a duplicate, there
is no previous location with which to calculate a distance. In that case,
the algorithm skips to (3) and keeps the first location.

In the event your \code{data.frame} does not have a DOP column, you can insert a dummy
with constant values such that all duplicates will tie, and distance will be
the only criterion (e.g., \code{x$dop <- 1}). In the event you do have an alternate
measure of precision where larger numbers are more precise (e.g., number of
satellites), simply multiply that metric by \code{-1} and pass it as if it were DOP.

Internally, the function drops duplicates as it works sequentially through the
\code{data.frame}. E.g., if location 5 was considered a duplicate of location 4 --
and location 4 was higher quality -- then location 5 would be dropped. The
function would then move on to location 6 (since 5 was already dropped).
However, the object returned to the user has all the original rows of \code{x} --
i.e., locations are flagged rather than removed.
}
\seealso{
\code{\link{flag_fast_steps}()},
\code{\link{flag_roundtrips}()},
\code{\link{flag_defunct_clusters}()}
}
\author{
Brian J. Smith, based on code by Johannes Signer and Tal Avgar
}
