# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Sample from multivariate normal distribution with C++
#' @description Simulates realizations from a multivariate normal with mean mu and covariance matrix sigma.
#' @param n number of simulations.
#' @param mu mean vector.
#' @param sigma covariance matrix or Cholesky decomposition of the matrix (see chol).
#' @param chol integer, if 0 sigma is a covariance matrix, otherwise it is the Cholesky decomposition of the matrix.
#' @return A matrix of size \eqn{d x n} containing the samples.
#' @examples
#' # Simulate 1000 realizations from a multivariate normal vector
#' mu <- rep(0,200)
#' Sigma <- diag(rep(1,200))
#' realizations<-mvrnormArma(n=1000,mu = mu,sigma=Sigma, chol=0)
#' empMean<-rowMeans(realizations)
#' empCov<-cov(t(realizations))
#' # check if the sample mean is close to the actual mean
#' maxErrorOnMean<-max(abs(mu-empMean))
#' # check if we can estimate correctly the covariance matrix
#' maxErrorOnVar<-max(abs(rep(1,200)-diag(empCov)))
#' maxErrorOnCov<-max(abs(empCov[lower.tri(empCov)]))
#' \dontrun{
#' plot(density(realizations[2,]))
#' }
#' @export
mvrnormArma <- function(n, mu, sigma, chol) {
    .Call('anMC_mvrnormArma', PACKAGE = 'anMC', n, mu, sigma, chol)
}

#' @title Sample from truncated multivariate normal distribution with C++
#' @description Simulates realizations from a truncated multivariate normal with mean mu, covariance matrix sigma in the bounds lower upper.
#' @param n number of simulations.
#' @param mu mean vector.
#' @param sigma covariance matrix.
#' @param lower vector of lower bounds.
#' @param upper vector of upper bounds.
#' @param verb level of verbosity: if lower than 3 nothing, 3 minimal, 4 extended.
#' @return A matrix of size \eqn{d x n} containing the samples.
#' @references Horrace, W. C. (2005). Some results on the multivariate truncated normal distribution. Journal of Multivariate Analysis, 94(1):209--221.
#'
#' Robert, C. P. (1995). Simulation of truncated normal variables. Statistics and Computing, 5(2):121--125.
#' @examples
#' # Simulate 1000 realizations from a truncated multivariate normal vector
#' mu <- rep(0,10)
#' Sigma <- diag(rep(1,10))
#' upper <- rep(3,10)
#' lower <- rep(-0.5,10)
#' realizations<-trmvrnorm_rej_cpp(n=1000,mu = mu,sigma=Sigma, lower =lower, upper= upper,verb=3)
#' empMean<-rowMeans(realizations)
#' empCov<-cov(t(realizations))
#' # check if the sample mean is close to the actual mean
#' maxErrorOnMean<-max(abs(mu-empMean))
#' # check if we can estimate correctly the covariance matrix
#' maxErrorOnVar<-max(abs(rep(1,200)-diag(empCov)))
#' maxErrorOnCov<-max(abs(empCov[lower.tri(empCov)]))
#' \dontrun{
#' plot(density(realizations[1,]))
#' hist(realizations[1,],breaks="FD")
#' }
#' @export
trmvrnorm_rej_cpp <- function(n, mu, sigma, lower, upper, verb) {
    .Call('anMC_trmvrnorm_rej_cpp', PACKAGE = 'anMC', n, mu, sigma, lower, upper, verb)
}

